/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.concurrent.atomic.LongAdder;
import org.jgroups.Message;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.conf.AttributeType;
import org.jgroups.stack.Protocol;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.ThreadPool;

@MBean(description="Unbatches messages from an OOB batch and delivers them in separate threads")
public class UNBATCH_OOB
extends Protocol {
    @Property(description="Enables or disables unbatching of OOB messages")
    protected boolean enabled = true;
    @Property(description="Skip OOB batches smaller than this value. 0 ignores this")
    protected int min_size;
    @ManagedAttribute(description="Number of unbatched OOB messages", type=AttributeType.SCALAR)
    protected final LongAdder num_unbatched_msgs = new LongAdder();
    @ManagedAttribute(description="Number of OOB batches which were unbatched", type=AttributeType.SCALAR)
    protected final LongAdder num_oob_batches = new LongAdder();
    protected ThreadPool thread_pool;

    public boolean enabled() {
        return this.enabled;
    }

    public UNBATCH_OOB enable(boolean enable) {
        this.enabled = enable;
        return this;
    }

    public int minSize() {
        return this.min_size;
    }

    public UNBATCH_OOB minSize(int min_size) {
        this.min_size = min_size;
        return this;
    }

    @ManagedAttribute(description="Number of unbatches messages per batch")
    public double avgUnbatchedMessagesPerBatch() {
        if (!this.enabled) {
            return 0.0;
        }
        return this.num_oob_batches.sum() == 0L ? 0.0 : (double)this.num_unbatched_msgs.sum() / (double)this.num_oob_batches.sum();
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_unbatched_msgs.reset();
        this.num_oob_batches.reset();
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.thread_pool = this.getTransport().getThreadPool();
        if (this.enabled && !this.thread_pool.getThreadFactory().useVirtualThreads()) {
            this.log.warn("%s: virtual threads are not available; setting enabled to false", this.local_addr);
            this.enabled = false;
        }
    }

    @Override
    public void up(MessageBatch batch) {
        if (!this.enabled || batch.mode() != MessageBatch.Mode.OOB) {
            this.up_prot.up(batch);
            return;
        }
        int size = batch.size();
        if (this.min_size > 0 && size < this.min_size) {
            this.up_prot.up(batch);
            return;
        }
        for (Message msg : batch) {
            boolean rc = this.thread_pool.execute(() -> this.passUp(msg));
            if (rc) continue;
            this.passUp(msg);
        }
        batch.clear();
        if (size > 0) {
            this.num_oob_batches.increment();
            this.num_unbatched_msgs.add(size);
        }
    }

    protected void passUp(Message msg) {
        try {
            this.up_prot.up(msg);
        }
        catch (Throwable t) {
            this.log.warn("%s: failed delivering message %s", this.local_addr, msg);
        }
    }
}

