/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.subsystem;

import java.util.HashMap;
import java.util.Map;

enum ConcurrentElement {
    CONCURRENT("concurrent"),
    CONTEXT_SERVICES("context-services"),
    CONTEXT_SERVICE("context-service"),
    MANAGED_THREAD_FACTORIES("managed-thread-factories"),
    MANAGED_THREAD_FACTORY("managed-thread-factory"),
    MANAGED_EXECUTOR_SERVICES("managed-executor-services"),
    MANAGED_EXECUTOR_SERVICE("managed-executor-service"),
    MANAGED_SCHEDULED_EXECUTOR_SERVICES("managed-scheduled-executor-services"),
    MANAGED_SCHEDULED_EXECUTOR_SERVICE("managed-scheduled-executor-service"),
    UNKNOWN(null);

    private final String name;
    private static final Map<String, ConcurrentElement> MAP;

    private ConcurrentElement(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static ConcurrentElement forName(String localName) {
        ConcurrentElement element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, ConcurrentElement> map = new HashMap<String, ConcurrentElement>();
        for (ConcurrentElement element : ConcurrentElement.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

