/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.function;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.counter.impl.entries.CounterKey;
import org.infinispan.counter.impl.entries.CounterValue;
import org.infinispan.counter.impl.externalizers.ExternalizerIds;
import org.infinispan.counter.impl.function.BaseFunction;
import org.infinispan.counter.impl.function.FunctionHelper;
import org.infinispan.counter.logging.Log;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.impl.CounterConfigurationMetaParam;

public final class SetFunction<K extends CounterKey>
extends BaseFunction<K, Object>
implements Serializable {
    public static final AdvancedExternalizer<SetFunction> EXTERNALIZER = new Externalizer();
    private static final Log log = (Log)LogFactory.getLog(SetFunction.class, Log.class);
    private final long value;

    public SetFunction(long value) {
        this.value = value;
    }

    @Override
    Object apply(EntryView.ReadWriteEntryView<K, CounterValue> entry, CounterConfigurationMetaParam metadata) {
        return FunctionHelper.set(entry, (CounterValue)entry.get(), metadata, this.value);
    }

    @Override
    protected Log getLog() {
        return log;
    }

    private static class Externalizer
    implements AdvancedExternalizer<SetFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends SetFunction>> getTypeClasses() {
            return Collections.singleton(SetFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.SET_FUNCTION;
        }

        public void writeObject(ObjectOutput output, SetFunction object) throws IOException {
            output.writeLong(object.value);
        }

        public SetFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new SetFunction(input.readLong());
        }
    }
}

