/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.operation.ParsedCommandLine;

public class SetVariableHandler
extends CommandHandlerWithHelp {
    public SetVariableHandler() {
        super("set");
        new ArgumentWithValue(this, new CommandLineCompleter(){

            @Override
            public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
                int equals = buffer.indexOf(61);
                if (equals < 1 || equals + 1 == buffer.length()) {
                    return -1;
                }
                String value = buffer.substring(equals + 1);
                if (value.startsWith("`")) {
                    value = value.substring(1);
                    int valueIndex = ctx.getDefaultCommandCompleter().complete(ctx, value, value.length(), candidates);
                    if (valueIndex < 0) {
                        return -1;
                    }
                    return equals + 1 + valueIndex + 1;
                }
                return -1;
            }
        }, Integer.MAX_VALUE, "--variable"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                return !SetVariableHandler.this.helpArg.isPresent(ctx.getParsedCommandLine());
            }
        };
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        ParsedCommandLine parsedArgs = ctx.getParsedCommandLine();
        List<String> vars = parsedArgs.getOtherProperties();
        if (vars.isEmpty()) {
            Collection<String> defined = ctx.getVariables();
            if (defined.isEmpty()) {
                return;
            }
            ArrayList<CallSite> pairs = new ArrayList<CallSite>(defined.size());
            for (String string : defined) {
                pairs.add((CallSite)((Object)(string + "=" + ctx.getVariable(string))));
            }
            Collections.sort(pairs);
            for (String string : pairs) {
                ctx.printLine(string);
            }
            return;
        }
        for (String arg : vars) {
            if ((arg = ArgumentWithValue.resolveValue(arg)).charAt(0) == '$' && (arg = arg.substring(1)).isEmpty()) {
                throw new CommandFormatException("Variable name is missing after '$'");
            }
            int equals = arg.indexOf(61);
            if (equals < 1) {
                throw new CommandFormatException("'=' is missing for variable '" + arg + "'");
            }
            String string = arg.substring(0, equals);
            if (string.isEmpty()) {
                throw new CommandFormatException("The name is missing in '" + arg + "'");
            }
            if (equals == arg.length() - 1) {
                ctx.setVariable(string, null);
                continue;
            }
            String value = arg.substring(equals + 1);
            if (value.length() > 2 && value.charAt(0) == '`' && value.charAt(value.length() - 1) == '`') {
                value = Util.getResult(ctx, value.substring(1, value.length() - 1));
            }
            ctx.setVariable(string, value);
        }
    }

    @Override
    protected void recognizeArguments(CommandContext ctx) throws CommandFormatException {
        ParsedCommandLine args = ctx.getParsedCommandLine();
        Set<String> propertyNames = args.getPropertyNames();
        if (!propertyNames.isEmpty()) {
            Collection<String> names;
            if (this.helpArg.isPresent(args)) {
                if (propertyNames.size() == 1) {
                    return;
                }
                names = new ArrayList<String>(propertyNames);
                names.remove(this.helpArg.getFullName());
                names.remove(this.helpArg.getShortName());
            } else {
                names = propertyNames;
            }
            throw new CommandFormatException("Unrecognized argument names: " + String.valueOf(names));
        }
    }
}

