/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web.deployment;

import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.xml.IntVersionSchema;
import org.jboss.as.controller.xml.VersionedFeature;
import org.jboss.as.controller.xml.VersionedNamespace;
import org.jboss.as.controller.xml.XMLAttribute;
import org.jboss.as.controller.xml.XMLCardinality;
import org.jboss.as.controller.xml.XMLChoice;
import org.jboss.as.controller.xml.XMLComponentFactory;
import org.jboss.as.controller.xml.XMLContent;
import org.jboss.as.controller.xml.XMLElement;
import org.jboss.as.controller.xml.XMLElementSchema;
import org.jboss.as.controller.xml.XMLSequence;
import org.jboss.as.controller.xml.XMLUsage;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.jbossallxml.JBossAllSchema;
import org.jboss.staxmapper.IntVersion;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.clustering.web.service.routing.RouteLocatorProvider;
import org.wildfly.clustering.web.service.session.DistributableSessionManagementConfiguration;
import org.wildfly.extension.clustering.web.deployment.DistributableWebDeploymentConfiguration;
import org.wildfly.extension.clustering.web.deployment.MutableDistributableWebDeploymentConfiguration;
import org.wildfly.extension.clustering.web.deployment.MutableHotRodSessionManagementConfiguration;
import org.wildfly.extension.clustering.web.deployment.MutableInfinispanSessionManagementConfiguration;
import org.wildfly.extension.clustering.web.deployment.MutableRankedRoutingConfiguration;
import org.wildfly.extension.clustering.web.deployment.MutableSessionManagementConfiguration;
import org.wildfly.extension.clustering.web.routing.LocalRouteLocatorProvider;
import org.wildfly.extension.clustering.web.routing.NullRouteLocatorProvider;
import org.wildfly.extension.clustering.web.routing.infinispan.PrimaryOwnerRouteLocatorProvider;
import org.wildfly.extension.clustering.web.routing.infinispan.RankedRouteLocatorProvider;
import org.wildfly.extension.clustering.web.session.DistributableSessionManagementProviderFactory;
import org.wildfly.extension.clustering.web.session.hotrod.HotRodSessionManagementProvider;
import org.wildfly.extension.clustering.web.session.infinispan.InfinispanSessionManagementProvider;

public enum DistributableWebDeploymentSchema implements XMLElementSchema<DistributableWebDeploymentSchema, MutableDistributableWebDeploymentConfiguration>,
JBossAllSchema<DistributableWebDeploymentSchema, DistributableWebDeploymentConfiguration>
{
    VERSION_1_0(1, 0),
    VERSION_2_0(2, 0),
    VERSION_3_0(3, 0),
    VERSION_4_0(4, 0),
    VERSION_5_0(5, 0);

    private final VersionedNamespace<IntVersion, DistributableWebDeploymentSchema> namespace;
    private final XMLComponentFactory<MutableDistributableWebDeploymentConfiguration, Void> factory = XMLComponentFactory.newInstance((IntVersionSchema)this);

    private DistributableWebDeploymentSchema(int major, int minor) {
        this.namespace = IntVersionSchema.createURN(List.of("jboss", this.getLocalName()), (IntVersion)new IntVersion(new int[]{major, minor}));
    }

    public String getLocalName() {
        return "distributable-web";
    }

    public VersionedNamespace<IntVersion, DistributableWebDeploymentSchema> getNamespace() {
        return this.namespace;
    }

    public void readElement(XMLExtendedStreamReader reader, MutableDistributableWebDeploymentConfiguration configuration) throws XMLStreamException {
        XMLElement element = (XMLElement)((XMLElement.Builder)this.factory.element(this.getQualifiedName()).withContent(this.sessionManagementChoice(configuration))).build();
        element.getReader().readElement(reader, (Object)configuration);
    }

    public DistributableWebDeploymentConfiguration parse(XMLExtendedStreamReader reader, DeploymentUnit unit) throws XMLStreamException {
        MutableDistributableWebDeploymentConfiguration configuration = new MutableDistributableWebDeploymentConfiguration(unit);
        this.readElement(reader, configuration);
        return configuration;
    }

    private XMLChoice<MutableDistributableWebDeploymentConfiguration, Void> sessionManagementChoice(MutableDistributableWebDeploymentConfiguration config) {
        return (XMLChoice)((XMLChoice.Builder)((XMLChoice.Builder)((XMLChoice.Builder)this.factory.choice().addElement(this.sessionManagementElement())).addElement(this.infinispanSessionManagementElement(config))).addElement(this.hotrodSessionManagementElement(config))).build();
    }

    private XMLElement<MutableDistributableWebDeploymentConfiguration, Void> sessionManagementElement() {
        return (XMLElement)((XMLElement.Builder)this.factory.element(this.resolve("session-management")).addAttribute(this.factory.attribute(this.resolve("name")).withConsumer(MutableDistributableWebDeploymentConfiguration::setSessionManagementName).build()).withContent((XMLSequence)((XMLSequence.Builder)((XMLSequence.Builder)this.factory.sequence().withCardinality((XMLCardinality)XMLCardinality.Single.OPTIONAL)).addElement(this.immutableClassElement(this.factory))).build())).build();
    }

    private XMLElement<MutableDistributableWebDeploymentConfiguration, Void> infinispanSessionManagementElement(MutableDistributableWebDeploymentConfiguration config) {
        XMLComponentFactory factory = XMLComponentFactory.newInstance((IntVersionSchema)this);
        List attributes = List.of(factory.attribute(this.resolve("cache-container")).withUsage((XMLUsage)XMLAttribute.Use.REQUIRED).withConsumer(MutableInfinispanSessionManagementConfiguration::setContainerName).build(), factory.attribute(this.resolve("cache")).withConsumer(MutableInfinispanSessionManagementConfiguration::setCacheName).build());
        XMLChoice.Builder affinityChoiceBuilder = (XMLChoice.Builder)this.affinityChoiceBuilder(factory).addElement(this.affinityElement("primary-owner-affinity", PrimaryOwnerRouteLocatorProvider::new));
        if (this.since((VersionedFeature)VERSION_2_0)) {
            affinityChoiceBuilder.addElement(this.rankedAffinityElement());
        }
        XMLChoice affinityChoice = (XMLChoice)affinityChoiceBuilder.build();
        return this.sessionManagementElement(config, MutableInfinispanSessionManagementConfiguration::new, factory, "infinispan-session-management", attributes, affinityChoice, InfinispanSessionManagementProvider::new);
    }

    private XMLElement<MutableDistributableWebDeploymentConfiguration, Void> hotrodSessionManagementElement(MutableDistributableWebDeploymentConfiguration config) {
        XMLComponentFactory factory = XMLComponentFactory.newInstance((IntVersionSchema)this);
        LinkedList attributes = new LinkedList();
        attributes.add(factory.attribute(this.resolve("remote-cache-container")).withUsage((XMLUsage)XMLAttribute.Use.REQUIRED).withConsumer(MutableHotRodSessionManagementConfiguration::setContainerName).build());
        attributes.add(factory.attribute(this.resolve("cache-configuration")).withConsumer(MutableHotRodSessionManagementConfiguration::setConfigurationName).build());
        if (this.since((VersionedFeature)VERSION_4_0) || !this.since((VersionedFeature)VERSION_5_0)) {
            attributes.add(factory.attribute(this.resolve("expiration-thread-pool-size")).build());
        }
        XMLChoice affinityChoice = (XMLChoice)this.affinityChoiceBuilder(factory).build();
        return this.sessionManagementElement(config, MutableHotRodSessionManagementConfiguration::new, factory, "hotrod-session-management", attributes, affinityChoice, HotRodSessionManagementProvider::new);
    }

    private <C extends MutableSessionManagementConfiguration> XMLElement<MutableDistributableWebDeploymentConfiguration, Void> sessionManagementElement(MutableDistributableWebDeploymentConfiguration config, BiFunction<UnaryOperator<String>, Consumer<String>, C> configFactory, XMLComponentFactory<C, Void> factory, String localName, Iterable<XMLAttribute<C, Void>> attributes, XMLChoice<C, Void> affinityChoice, final DistributableSessionManagementProviderFactory providerFactory) {
        XMLElement.Builder builder = factory.element(this.resolve(localName)).addAttributes(attributes).addAttribute(factory.attribute(this.resolve("granularity")).withUsage((XMLUsage)XMLAttribute.Use.REQUIRED).withConsumer(MutableSessionManagementConfiguration::setSessionGranularity).build());
        if (this.since((VersionedFeature)VERSION_3_0)) {
            builder.addAttribute(factory.attribute(this.resolve("marshaller")).withConsumer(MutableSessionManagementConfiguration::setMarshallerFactory).build());
        }
        XMLSequence sequence = (XMLSequence)((XMLSequence.Builder)((XMLSequence.Builder)factory.sequence().addChoice(affinityChoice)).addElement(this.immutableClassElement(factory))).build();
        XMLElement element = (XMLElement)((XMLElement.Builder)builder.withContent(sequence)).build();
        return element.withContext(() -> (MutableSessionManagementConfiguration)configFactory.apply(config, config), new BiConsumer<MutableDistributableWebDeploymentConfiguration, C>(){

            @Override
            public void accept(MutableDistributableWebDeploymentConfiguration config, C sessionManagementConfig) {
                config.setSessionManagementProvider(providerFactory.createSessionManagementProvider((DistributableSessionManagementConfiguration<DeploymentUnit>)sessionManagementConfig, (BinaryServiceConfiguration)sessionManagementConfig, ((MutableSessionManagementConfiguration)sessionManagementConfig).getRouteLocatorProvider()));
            }
        }, Function.identity());
    }

    private <C extends Consumer<String>> XMLElement<C, Void> immutableClassElement(XMLComponentFactory<C, Void> factory) {
        return (XMLElement)((XMLElement.Builder)((XMLElement.Builder)factory.element(this.resolve("immutable-class")).withContent(XMLContent.of(Consumer::accept))).withCardinality((XMLCardinality)XMLCardinality.Unbounded.OPTIONAL)).build();
    }

    private <C extends MutableSessionManagementConfiguration> XMLChoice.Builder<C, Void> affinityChoiceBuilder(XMLComponentFactory<C, Void> factory) {
        return (XMLChoice.Builder)((XMLChoice.Builder)factory.choice().addElement(this.affinityElement("no-affinity", NullRouteLocatorProvider::new))).addElement(this.affinityElement("local-affinity", LocalRouteLocatorProvider::new));
    }

    private <C extends MutableSessionManagementConfiguration> XMLElement<C, Void> affinityElement(String localName, Supplier<RouteLocatorProvider> contextFactory) {
        XMLComponentFactory factory = XMLComponentFactory.newInstance((IntVersionSchema)this);
        return ((XMLElement)factory.element(this.resolve(localName)).build()).withContext(contextFactory, MutableSessionManagementConfiguration::setRouteLocatorProvider, Function.identity());
    }

    private <C extends MutableSessionManagementConfiguration> XMLElement<C, Void> rankedAffinityElement() {
        XMLComponentFactory factory = XMLComponentFactory.newInstance((IntVersionSchema)this);
        XMLElement element = (XMLElement)factory.element(this.resolve("ranked-affinity")).addAttribute(factory.attribute(this.resolve("delimiter")).withConsumer(MutableRankedRoutingConfiguration::setDelimiter).build()).addAttribute(factory.attribute(this.resolve("max-routes")).withConsumer(MutableRankedRoutingConfiguration::setMaxMembers).build()).build();
        return element.withContext(MutableRankedRoutingConfiguration::new, new BiConsumer<C, MutableRankedRoutingConfiguration>(){

            @Override
            public void accept(C config, MutableRankedRoutingConfiguration routingConfig) {
                ((MutableSessionManagementConfiguration)config).setRouteLocatorProvider(new RankedRouteLocatorProvider(routingConfig));
            }
        }, Function.identity());
    }
}

