/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl;

import io.netty.handler.codec.DecoderException;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.transaction.xa.Xid;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.impl.operations.ManagerOperationsFactory;
import org.infinispan.client.hotrod.impl.transport.netty.OperationDispatcher;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.WrappedByteArray;

public class Util {
    private static final long BIG_DELAY_NANOS = TimeUnit.DAYS.toNanos(1L);
    private static final Xid DUMMY_XID = new Xid(){

        @Override
        public int getFormatId() {
            return 0;
        }

        @Override
        public byte[] getGlobalTransactionId() {
            return new byte[]{1};
        }

        @Override
        public byte[] getBranchQualifier() {
            return new byte[]{1};
        }
    };

    private Util() {
    }

    public static <T> T await(CompletionStage<T> cf) {
        return Util.await(cf.toCompletableFuture());
    }

    public static <T> T await(CompletableFuture<T> cf) {
        try {
            return cf.get(BIG_DELAY_NANOS, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new HotRodClientException(e);
        }
        catch (ExecutionException e) {
            throw Util.rewrap(e);
        }
        catch (TimeoutException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T await(CompletionStage<T> cf, long timeoutMillis) {
        return Util.await(cf.toCompletableFuture(), timeoutMillis);
    }

    public static <T> T await(CompletableFuture<T> cf, long timeoutMillis) {
        try {
            return cf.get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new HotRodClientException(e);
        }
        catch (ExecutionException e) {
            throw Util.rewrap(e);
        }
        catch (TimeoutException e) {
            cf.cancel(false);
            throw new TransportException(new SocketTimeoutException(), null);
        }
    }

    public static HotRodClientException rewrap(Throwable t) {
        Throwable cause = t;
        while ((cause instanceof CompletionException || cause instanceof DecoderException || cause instanceof TransportException) && cause.getCause() != null) {
            cause = cause.getCause();
        }
        if (cause instanceof HotRodClientException) {
            HotRodClientException hrce = (HotRodClientException)cause;
            return hrce;
        }
        if (t instanceof HotRodClientException) {
            HotRodClientException hrce = (HotRodClientException)t;
            return hrce;
        }
        return new TransportException(t, null);
    }

    protected static RuntimeException rewrap(ExecutionException e) {
        Throwable cause = e.getCause();
        if (cause instanceof HotRodClientException) {
            cause.setStackTrace(e.getStackTrace());
            return (HotRodClientException)cause;
        }
        if (cause instanceof CacheException) {
            return new CacheException(cause);
        }
        return new TransportException(cause, null);
    }

    public static CompletionStage<Boolean> checkTransactionSupport(String cacheName, ManagerOperationsFactory operationsFactory, OperationDispatcher dispatcher) {
        HotRodOperation<Integer> op = operationsFactory.newPrepareTransaction(cacheName, DUMMY_XID, true, Collections.emptyList(), false, 60000L);
        return dispatcher.execute(op).handle((integer, throwable) -> {
            if (throwable != null) {
                Log.HOTROD.invalidTxServerConfig(cacheName, (Throwable)throwable);
            }
            return throwable == null;
        });
    }

    public static boolean checkTransactionSupport(String cacheName, ManagerOperationsFactory factory, OperationDispatcher dispatcher, Log log) {
        HotRodOperation<Integer> op = factory.newPrepareTransaction(cacheName, DUMMY_XID, true, Collections.emptyList(), false, 60000L);
        try {
            return dispatcher.execute(op).handle((integer, throwable) -> {
                if (throwable != null) {
                    Log.HOTROD.invalidTxServerConfig(cacheName, (Throwable)throwable);
                }
                return throwable == null;
            }).toCompletableFuture().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            log.debugf("Exception while checking transaction support in server", e);
        }
        return false;
    }

    public static WrappedByteArray wrapBytes(byte[] cacheName) {
        WrappedByteArray wrappedCacheName = cacheName == null || cacheName.length == 0 ? WrappedByteArray.EMPTY_BYTES : new WrappedByteArray(cacheName);
        return wrappedCacheName;
    }
}

