/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.util.function.Supplier;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RestartParentResourceAddHandler;
import org.jboss.as.controller.RestartParentResourceRemoveHandler;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.JmxAuthorizer;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.extension.RuntimeHostControllerInfoAccessor;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.jmx.ExposeModelResourceExpression;
import org.jboss.as.jmx.ExposeModelResourceResolved;
import org.jboss.as.jmx.JMXExtension;
import org.jboss.as.jmx.JMXSubsystemAdd;
import org.jboss.as.jmx.MBeanServerService;
import org.jboss.as.jmx.logging.JmxLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.wildfly.security.auth.server.SecurityIdentity;

abstract class ExposeModelResource
extends SimpleResourceDefinition {
    private final ManagedAuditLogger auditLoggerInfo;
    private final JmxAuthorizer authorizer;
    private final Supplier<SecurityIdentity> securityIdentitySupplier;
    private final SimpleAttributeDefinition domainName;
    private final RuntimeHostControllerInfoAccessor hostInfoAccessor;

    ExposeModelResource(PathElement pathElement, ManagedAuditLogger auditLoggerInfo, JmxAuthorizer authorizer, Supplier<SecurityIdentity> securityIdentitySupplier, RuntimeHostControllerInfoAccessor hostInfoAccessor, SimpleAttributeDefinition domainName, SimpleAttributeDefinition ... otherAttributes) {
        super(pathElement, JMXExtension.getResourceDescriptionResolver("expose-model." + pathElement.getValue()), (OperationStepHandler)new ShowModelAdd(auditLoggerInfo, authorizer, securityIdentitySupplier, domainName, hostInfoAccessor, otherAttributes), (OperationStepHandler)new ShowModelRemove(auditLoggerInfo, authorizer, securityIdentitySupplier, hostInfoAccessor));
        this.auditLoggerInfo = auditLoggerInfo;
        this.authorizer = authorizer;
        this.securityIdentitySupplier = securityIdentitySupplier;
        this.domainName = domainName;
        this.hostInfoAccessor = hostInfoAccessor;
    }

    static SimpleAttributeDefinition getDomainNameAttribute(String childName) {
        if ("resolved".equals(childName)) {
            return ExposeModelResourceResolved.DOMAIN_NAME;
        }
        if ("expression".equals(childName)) {
            return ExposeModelResourceExpression.DOMAIN_NAME;
        }
        throw JmxLogger.ROOT_LOGGER.unknownChild(childName);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)this.domainName, null, (OperationStepHandler)new JMXWriteAttributeHandler(this.hostInfoAccessor, (AttributeDefinition)this.domainName));
    }

    private static class ShowModelAdd
    extends RestartParentResourceAddHandler {
        private final ManagedAuditLogger auditLoggerInfo;
        private final JmxAuthorizer authorizer;
        private final Supplier<SecurityIdentity> securityIdentitySupplier;
        private final SimpleAttributeDefinition domainName;
        private final SimpleAttributeDefinition[] otherAttributes;
        private final RuntimeHostControllerInfoAccessor hostInfoAccessor;

        private ShowModelAdd(ManagedAuditLogger auditLoggerInfo, JmxAuthorizer authorizer, Supplier<SecurityIdentity> securityIdentitySupplier, SimpleAttributeDefinition domainName, RuntimeHostControllerInfoAccessor hostInfoAccessor, SimpleAttributeDefinition ... otherAttributes) {
            super("subsystem");
            this.auditLoggerInfo = auditLoggerInfo;
            this.authorizer = authorizer;
            this.securityIdentitySupplier = securityIdentitySupplier;
            this.domainName = domainName;
            this.otherAttributes = otherAttributes;
            this.hostInfoAccessor = hostInfoAccessor;
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            this.domainName.validateAndSet(operation, model);
            if (this.otherAttributes.length > 0) {
                for (SimpleAttributeDefinition attr : this.otherAttributes) {
                    attr.validateAndSet(operation, model);
                }
            }
        }

        protected void recreateParentService(OperationContext context, ModelNode parentModel) throws OperationFailedException {
            JMXSubsystemAdd.launchServices(context, parentModel, this.auditLoggerInfo, this.authorizer, this.securityIdentitySupplier, this.hostInfoAccessor);
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return MBeanServerService.SERVICE_NAME;
        }
    }

    private static class ShowModelRemove
    extends RestartParentResourceRemoveHandler {
        private final ManagedAuditLogger auditLoggerInfo;
        private final JmxAuthorizer authorizer;
        private final Supplier<SecurityIdentity> securityIdentitySupplier;
        private final RuntimeHostControllerInfoAccessor hostInfoAccessor;

        private ShowModelRemove(ManagedAuditLogger auditLoggerInfo, JmxAuthorizer authorizer, Supplier<SecurityIdentity> securityIdentitySupplier, RuntimeHostControllerInfoAccessor hostInfoAccessor) {
            super("subsystem");
            this.auditLoggerInfo = auditLoggerInfo;
            this.authorizer = authorizer;
            this.securityIdentitySupplier = securityIdentitySupplier;
            this.hostInfoAccessor = hostInfoAccessor;
        }

        protected void recreateParentService(OperationContext context, ModelNode parentModel) throws OperationFailedException {
            JMXSubsystemAdd.launchServices(context, parentModel, this.auditLoggerInfo, this.authorizer, this.securityIdentitySupplier, this.hostInfoAccessor);
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return MBeanServerService.SERVICE_NAME;
        }
    }

    class JMXWriteAttributeHandler
    extends RestartParentWriteAttributeHandler {
        private final RuntimeHostControllerInfoAccessor hostInfoAccessor;

        JMXWriteAttributeHandler(RuntimeHostControllerInfoAccessor hostInfoAccessor, AttributeDefinition attr) {
            super("subsystem", new AttributeDefinition[]{attr});
            this.hostInfoAccessor = hostInfoAccessor;
        }

        protected void recreateParentService(OperationContext context, ModelNode parentModel) throws OperationFailedException {
            JMXSubsystemAdd.launchServices(context, parentModel, ExposeModelResource.this.auditLoggerInfo, ExposeModelResource.this.authorizer, ExposeModelResource.this.securityIdentitySupplier, this.hostInfoAccessor);
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return MBeanServerService.SERVICE_NAME;
        }
    }
}

