/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.commons.util.TimeQuantity;
import org.infinispan.configuration.cache.XSiteStateTransferMode;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;

public class XSiteStateTransferConfiguration
extends ConfigurationElement<XSiteStateTransferConfiguration> {
    public static final int DEFAULT_CHUNK_SIZE = 512;
    public static final TimeQuantity DEFAULT_TIMEOUT = TimeQuantity.valueOf((String)"20m");
    public static final int DEFAULT_MAX_RETRIES = 30;
    public static final TimeQuantity DEFAULT_WAIT_TIME = TimeQuantity.valueOf((String)"2s");
    public static final AttributeDefinition<Integer> CHUNK_SIZE = AttributeDefinition.builder((Enum)Attribute.CHUNK_SIZE, (Object)512).immutable().build();
    public static final AttributeDefinition<TimeQuantity> TIMEOUT = AttributeDefinition.builder((Enum)Attribute.TIMEOUT, (Object)DEFAULT_TIMEOUT).parser(TimeQuantity.PARSER).build();
    public static final AttributeDefinition<Integer> MAX_RETRIES = AttributeDefinition.builder((Enum)Attribute.MAX_RETRIES, (Object)30).build();
    public static final AttributeDefinition<TimeQuantity> WAIT_TIME = AttributeDefinition.builder((Enum)Attribute.WAIT_TIME, (Object)DEFAULT_WAIT_TIME).parser(TimeQuantity.PARSER).build();
    public static final AttributeDefinition<XSiteStateTransferMode> MODE = AttributeDefinition.builder((Enum)Attribute.MODE, (Object)((Object)XSiteStateTransferMode.MANUAL)).build();

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(XSiteStateTransferConfiguration.class, new AttributeDefinition[]{CHUNK_SIZE, TIMEOUT, MAX_RETRIES, WAIT_TIME, MODE});
    }

    public XSiteStateTransferConfiguration(AttributeSet attributes) {
        super((Enum)Element.STATE_TRANSFER, attributes, new ConfigurationElement[0]);
    }

    public int chunkSize() {
        return (Integer)this.attributes.attribute(CHUNK_SIZE).get();
    }

    public long timeout() {
        return ((TimeQuantity)this.attributes.attribute(TIMEOUT).get()).longValue();
    }

    public int maxRetries() {
        return (Integer)this.attributes.attribute(MAX_RETRIES).get();
    }

    public long waitTime() {
        return ((TimeQuantity)this.attributes.attribute(WAIT_TIME).get()).longValue();
    }

    public XSiteStateTransferMode mode() {
        return (XSiteStateTransferMode)((Object)this.attributes.attribute(MODE).get());
    }
}

