/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.attributes.AttributeCopier;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeInitializer;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.IdentityAttributeCopier;
import org.infinispan.configuration.global.GlobalAuthorizationConfigurationBuilder;
import org.infinispan.configuration.global.PrincipalRoleMapperConfiguration;
import org.infinispan.configuration.global.RolePermissionMapperConfiguration;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.security.AuditLogger;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Role;
import org.infinispan.security.RolePermissionMapper;
import org.infinispan.security.audit.NullAuditLogger;
import org.infinispan.util.logging.events.Messages;

@BuiltBy(value=GlobalAuthorizationConfigurationBuilder.class)
public class GlobalAuthorizationConfiguration {
    public static final Map<String, Role> DEFAULT_ROLES;
    public static final AttributeDefinition<Boolean> ENABLED;
    public static final AttributeDefinition<AuditLogger> AUDIT_LOGGER;
    public static final AttributeDefinition<Map<String, Role>> ROLES;
    public static final AttributeDefinition<Boolean> GROUP_ONLY_MAPPING;
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> enabled;
    private final org.infinispan.commons.configuration.attributes.Attribute<AuditLogger> auditLogger;
    private final Map<String, Role> roles;
    private final PrincipalRoleMapperConfiguration roleMapperConfiguration;
    private final RolePermissionMapperConfiguration permissionMapperConfiguration;
    private final RolePermissionMapper rolePermissionMapper;
    private final boolean groupOnlyMapping;
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(GlobalAuthorizationConfiguration.class, new AttributeDefinition[]{ENABLED, AUDIT_LOGGER, ROLES, GROUP_ONLY_MAPPING});
    }

    public GlobalAuthorizationConfiguration(AttributeSet attributes, PrincipalRoleMapperConfiguration roleMapperConfiguration, RolePermissionMapperConfiguration permissionMapperConfiguration) {
        this.attributes = attributes.checkProtection();
        this.enabled = attributes.attribute(ENABLED);
        this.auditLogger = attributes.attribute(AUDIT_LOGGER);
        this.roles = (Map)attributes.attribute(ROLES).get();
        this.roleMapperConfiguration = roleMapperConfiguration;
        this.permissionMapperConfiguration = permissionMapperConfiguration;
        this.rolePermissionMapper = permissionMapperConfiguration.permissionMapper();
        this.groupOnlyMapping = (Boolean)attributes.attribute(GROUP_ONLY_MAPPING).get();
    }

    public boolean enabled() {
        return (Boolean)this.enabled.get();
    }

    public AuditLogger auditLogger() {
        return (AuditLogger)this.auditLogger.get();
    }

    public PrincipalRoleMapper principalRoleMapper() {
        return this.roleMapperConfiguration.roleMapper();
    }

    public RolePermissionMapper rolePermissionMapper() {
        return this.rolePermissionMapper;
    }

    public PrincipalRoleMapperConfiguration roleMapperConfiguration() {
        return this.roleMapperConfiguration;
    }

    public boolean isDefaultRoles() {
        return DEFAULT_ROLES.equals(this.roles);
    }

    public boolean groupOnlyMapping() {
        return this.groupOnlyMapping;
    }

    public RolePermissionMapperConfiguration permissionMapperConfiguration() {
        return this.permissionMapperConfiguration;
    }

    public Map<String, Role> roles() {
        HashMap<String, Role> all = new HashMap<String, Role>(this.roles);
        if (this.rolePermissionMapper != null) {
            all.putAll(this.rolePermissionMapper.getAllRoles());
        }
        return all;
    }

    public void addRole(Role role) {
        this.roles.put(role.getName(), role);
    }

    public boolean hasRole(String name) {
        return this.roles.containsKey(name) || this.rolePermissionMapper != null && this.rolePermissionMapper.hasRole(name);
    }

    public Role getRole(String name) {
        Role role = this.roles.get(name);
        if (role != null) {
            return role;
        }
        if (this.rolePermissionMapper != null) {
            return this.rolePermissionMapper.getRole(name);
        }
        return null;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalAuthorizationConfiguration that = (GlobalAuthorizationConfiguration)o;
        return Objects.equals(this.roleMapperConfiguration, that.roleMapperConfiguration) && Objects.equals(this.permissionMapperConfiguration, that.permissionMapperConfiguration) && Objects.equals(this.attributes, that.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.roleMapperConfiguration, this.permissionMapperConfiguration, this.attributes);
    }

    public String toString() {
        return "GlobalAuthorizationConfiguration{roleMapperConfiguration=" + String.valueOf(this.roleMapperConfiguration) + "permissionMapperConfiguration=" + String.valueOf(this.permissionMapperConfiguration) + ", attributes=" + String.valueOf(this.attributes) + "}";
    }

    static {
        ENABLED = AttributeDefinition.builder((Enum)Attribute.ENABLED, (Object)false).immutable().build();
        AUDIT_LOGGER = AttributeDefinition.builder((Enum)Attribute.AUDIT_LOGGER, (Object)new NullAuditLogger()).copier((AttributeCopier)IdentityAttributeCopier.identityCopier()).serializer(AttributeSerializer.INSTANCE_CLASS_NAME).immutable().build();
        ROLES = AttributeDefinition.builder((Enum)Attribute.ROLES, new HashMap()).initializer((AttributeInitializer)new AttributeInitializer<Map<String, Role>>(){

            public Map<String, Role> initialize() {
                return new HashMap<String, Role>(DEFAULT_ROLES);
            }
        }).build();
        GROUP_ONLY_MAPPING = AttributeDefinition.builder((Enum)Attribute.GROUP_ONLY_MAPPING, (Object)true, Boolean.class).immutable().build();
        DEFAULT_ROLES = Map.of("admin", Role.newRole("admin", Messages.MESSAGES.adminRoleDescription(), true, true, AuthorizationPermission.ALL), "application", Role.newRole("application", Messages.MESSAGES.applicationRoleDescription(), true, true, AuthorizationPermission.ALL_READ, AuthorizationPermission.ALL_WRITE, AuthorizationPermission.LISTEN, AuthorizationPermission.EXEC, AuthorizationPermission.MONITOR), "deployer", Role.newRole("deployer", Messages.MESSAGES.deployerRoleDescription(), true, true, AuthorizationPermission.ALL_READ, AuthorizationPermission.ALL_WRITE, AuthorizationPermission.LISTEN, AuthorizationPermission.EXEC, AuthorizationPermission.CREATE, AuthorizationPermission.MONITOR), "observer", Role.newRole("observer", Messages.MESSAGES.observerRoleDescription(), true, true, AuthorizationPermission.ALL_READ, AuthorizationPermission.MONITOR), "monitor", Role.newRole("monitor", Messages.MESSAGES.monitorRoleDescription(), true, true, AuthorizationPermission.MONITOR), "___schema_manager", Role.newRole("___schema_manager", "Deprecated role for schema management.", true, false, AuthorizationPermission.CREATE), "___script_manager", Role.newRole("___script_manager", "Deprecated role for script management.", true, false, AuthorizationPermission.CREATE));
    }
}

