/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.context;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.wildfly.clustering.context.Context;
import org.wildfly.clustering.function.Consumer;

public interface ContextReference<C>
extends Supplier<C>,
java.util.function.Consumer<C>,
UnaryOperator<C> {
    public static <C> ContextReference<C> fromThreadLocal(final ThreadLocal<C> threadLocal) {
        return new ContextReference<C>(){

            @Override
            public C get() {
                return threadLocal.get();
            }

            @Override
            public void accept(C context) {
                if (context != null) {
                    threadLocal.set(context);
                } else {
                    threadLocal.remove();
                }
            }
        };
    }

    public static <C> ContextReference<C> of(org.wildfly.clustering.function.Supplier<C> supplier, Consumer<C> consumer) {
        return new SimpleContextReference<C>(supplier, consumer);
    }

    public static <C> ContextReference<C> of(org.wildfly.clustering.function.Supplier<C> supplier, Consumer<C> consumer, final org.wildfly.clustering.function.UnaryOperator<C> operator) {
        return new SimpleContextReference<C>(supplier, consumer){

            @Override
            public C apply(C context) {
                return operator.apply(context);
            }
        };
    }

    public static <C> ContextReference<C> of(AtomicReference<C> reference) {
        return ContextReference.of(reference::get, reference::set, reference::getAndSet);
    }

    @Override
    default public C apply(C context) {
        Object current = this.get();
        this.accept(context);
        return (C)current;
    }

    default public Supplier<Context<C>> provide(final C target) {
        return target != null ? new org.wildfly.clustering.function.Supplier<Context<C>>(){

            public Context<C> get() {
                final Object existing = ContextReference.this.get();
                if (existing == target) {
                    return Context.empty();
                }
                ContextReference.this.accept(target);
                return new Context<C>(){

                    @Override
                    public C get() {
                        return target;
                    }

                    @Override
                    public void close() {
                        ContextReference.this.accept(existing);
                    }
                };
            }
        } : org.wildfly.clustering.function.Supplier.of(Context.empty());
    }

    public static class SimpleContextReference<C>
    implements ContextReference<C> {
        private final org.wildfly.clustering.function.Supplier<C> supplier;
        private final Consumer<C> consumer;

        SimpleContextReference(org.wildfly.clustering.function.Supplier<C> supplier, Consumer<C> consumer) {
            this.supplier = supplier;
            this.consumer = consumer;
        }

        @Override
        public C get() {
            return (C)this.supplier.get();
        }

        @Override
        public void accept(C context) {
            this.consumer.accept(context);
        }
    }
}

