/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.mwlabs.wscf.model.sagas.arjunacore;

import com.arjuna.ats.arjuna.coordinator.ActionStatus;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.mw.wsas.UserActivityFactory;
import com.arjuna.mw.wsas.activity.ActivityHierarchy;
import com.arjuna.mw.wsas.activity.Outcome;
import com.arjuna.mw.wsas.completionstatus.CompletionStatus;
import com.arjuna.mw.wsas.completionstatus.Success;
import com.arjuna.mw.wsas.exceptions.NoActivityException;
import com.arjuna.mw.wsas.exceptions.ProtocolViolationException;
import com.arjuna.mw.wsas.exceptions.SystemException;
import com.arjuna.mw.wsas.exceptions.WrongStateException;
import com.arjuna.mw.wsas.status.Active;
import com.arjuna.mw.wsas.status.NoActivity;
import com.arjuna.mw.wsas.status.Status;
import com.arjuna.mw.wsas.status.Unknown;
import com.arjuna.mw.wscf.common.CoordinatorId;
import com.arjuna.mw.wscf.common.Qualifier;
import com.arjuna.mw.wscf.exceptions.BegunFailedException;
import com.arjuna.mw.wscf.exceptions.DuplicateParticipantException;
import com.arjuna.mw.wscf.exceptions.InvalidParticipantException;
import com.arjuna.mw.wscf.exceptions.NoCoordinatorException;
import com.arjuna.mw.wscf.exceptions.UnexpectedException;
import com.arjuna.mw.wscf.logging.wscfLogger;
import com.arjuna.mw.wscf.model.sagas.outcomes.CoordinationOutcome;
import com.arjuna.mw.wscf.model.sagas.participants.Participant;
import com.arjuna.mw.wscf.model.sagas.status.CancelOnly;
import com.arjuna.mw.wscf.model.sagas.status.Cancelled;
import com.arjuna.mw.wscf.model.sagas.status.Cancelling;
import com.arjuna.mw.wscf.model.sagas.status.Closed;
import com.arjuna.mw.wscf.model.sagas.status.Closing;
import com.arjuna.mwlabs.wsas.activity.ActivityHandleImple;
import com.arjuna.mwlabs.wscf.model.sagas.arjunacore.BACoordinator;
import com.arjuna.mwlabs.wscf.model.sagas.arjunacore.subordinate.SubordinateBACoordinator;
import java.util.Hashtable;

public class CoordinatorControl {
    private static Hashtable _coordinators = new Hashtable();

    public void begin() throws SystemException {
        try {
            BACoordinator coord = new BACoordinator();
            int status = coord.start((BasicAction)this.parentCoordinator());
            if (status != 0) {
                throw new BegunFailedException(wscfLogger.i18NLogger.get_model_sagas_arjunacore_CoordinatorControl_1() + ActionStatus.stringForm((int)status));
            }
            _coordinators.put(this.currentActivity(), coord);
        }
        catch (SystemException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new UnexpectedException(ex.toString());
        }
    }

    public Outcome complete(CompletionStatus cs) throws SystemException {
        BACoordinator current = this.currentCoordinator();
        int outcome = cs != null && cs instanceof Success ? current.close() : current.cancel();
        _coordinators.remove(this.currentActivity());
        return new CoordinationOutcome(cs, switch (outcome) {
            case 4 -> 10;
            case 7 -> 11;
            case 11 -> 3;
            case 12 -> 4;
            case 13 -> 5;
            case 14 -> 6;
            default -> 8;
        });
    }

    public void complete() throws WrongStateException, SystemException {
        this.currentCoordinator().complete();
    }

    public void suspend() throws SystemException {
    }

    public void resume() throws SystemException {
    }

    public void completed() throws SystemException {
    }

    public Outcome coordinate(CompletionStatus cs) throws WrongStateException, ProtocolViolationException, SystemException {
        return null;
    }

    public Status status() throws SystemException {
        int currentStatus = this.currentCoordinator().status();
        switch (currentStatus) {
            case 0: 
            case 8: {
                return Active.instance();
            }
            case 1: 
            case 5: 
            case 6: {
                return Closing.instance();
            }
            case 7: {
                return Closed.instance();
            }
            case 2: {
                return Cancelling.instance();
            }
            case 4: {
                return Cancelled.instance();
            }
            case 3: {
                return CancelOnly.instance();
            }
            case 16: {
                return NoActivity.instance();
            }
        }
        return Unknown.instance();
    }

    public Qualifier[] qualifiers() throws NoCoordinatorException, SystemException {
        return this.currentCoordinator().qualifiers();
    }

    public CoordinatorId identifier() throws NoCoordinatorException, SystemException {
        return this.currentCoordinator().identifier();
    }

    public void enlistParticipant(Participant act) throws WrongStateException, DuplicateParticipantException, InvalidParticipantException, NoCoordinatorException, SystemException {
        this.currentCoordinator().enlistParticipant(act);
    }

    public void delistParticipant(String participantId) throws InvalidParticipantException, NoCoordinatorException, WrongStateException, SystemException {
        this.currentCoordinator().delistParticipant(participantId);
    }

    public void participantCompleted(String participantId) throws NoActivityException, InvalidParticipantException, WrongStateException, SystemException {
        this.currentCoordinator().participantCompleted(participantId);
    }

    public void participantFaulted(String participantId) throws NoActivityException, InvalidParticipantException, SystemException {
        this.currentCoordinator().participantFaulted(participantId);
    }

    public void participantCannotComplete(String participantId) throws NoActivityException, InvalidParticipantException, WrongStateException, SystemException {
        this.currentCoordinator().participantCannotComplete(participantId);
    }

    public final BACoordinator createSubordinate() throws SystemException {
        try {
            SubordinateBACoordinator coord = new SubordinateBACoordinator();
            int status = coord.start(null);
            if (status != 0) {
                throw new BegunFailedException(wscfLogger.i18NLogger.get_model_sagas_arjunacore_CoordinatorControl_1() + ActionStatus.stringForm((int)status));
            }
            return coord;
        }
        catch (SystemException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new UnexpectedException(ex.toString());
        }
    }

    public final BACoordinator currentCoordinator() throws NoCoordinatorException, SystemException {
        BACoordinator coord = (BACoordinator)((Object)_coordinators.get(this.currentActivity()));
        if (coord == null) {
            throw new NoCoordinatorException();
        }
        return coord;
    }

    private final ActivityHandleImple currentActivity() throws SystemException {
        try {
            ActivityHierarchy hier = UserActivityFactory.userActivity().currentActivity();
            if (hier.size() > 0) {
                return (ActivityHandleImple)hier.activity(hier.size() - 1);
            }
            return null;
        }
        catch (Exception ex) {
            wscfLogger.i18NLogger.warn_unexpectedException(ex);
            throw new SystemException(ex.toString());
        }
    }

    private final BACoordinator parentCoordinator() throws SystemException {
        try {
            ActivityHierarchy hier = UserActivityFactory.userActivity().currentActivity();
            ActivityHandleImple parentActivity = null;
            BACoordinator parentCoordinator = null;
            if (hier.size() > 1) {
                parentActivity = (ActivityHandleImple)hier.activity(hier.size() - 2);
                parentCoordinator = (BACoordinator)((Object)_coordinators.get(parentActivity));
            }
            return parentCoordinator;
        }
        catch (Exception ex) {
            wscfLogger.i18NLogger.warn_unexpectedException(ex);
            return null;
        }
    }
}

