/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jbossts.xts.recovery.coordinator.ba;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.ActionStatus;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.objectstore.RecoveryStore;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.objectstore.TxLog;
import com.arjuna.ats.arjuna.recovery.TransactionStatusConnectionManager;
import com.arjuna.ats.arjuna.state.InputBuffer;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import com.arjuna.mwlabs.wscf.model.sagas.arjunacore.BACoordinator;
import java.util.Enumeration;
import java.util.Vector;
import org.jboss.jbossts.xts.recovery.XTSRecoveryModule;
import org.jboss.jbossts.xts.recovery.coordinator.ba.Implementations;
import org.jboss.jbossts.xts.recovery.coordinator.ba.RecoveryBACoordinator;
import org.jboss.jbossts.xts.recovery.logging.RecoveryLogger;
import org.jboss.jbossts.xts.recovery.participant.ba.XTSBARecoveryManager;
import org.jboss.jbossts.xts.recovery.participant.ba.XTSBARecoveryManagerImple;

public class BACoordinatorRecoveryModule
implements XTSRecoveryModule {
    private String _transactionType = new BACoordinator().type();
    private Vector _transactionUidVector = null;
    private static RecoveryStore _recoveryStore = null;
    private TransactionStatusConnectionManager _transactionStatusConnectionMgr;

    public BACoordinatorRecoveryModule() {
        if (RecoveryLogger.logger.isDebugEnabled()) {
            RecoveryLogger.logger.debug((Object)"BACoordinatorRecoveryModule created - default");
        }
        if (_recoveryStore == null) {
            _recoveryStore = StoreManager.getRecoveryStore();
        }
        this._transactionStatusConnectionMgr = new TransactionStatusConnectionManager();
    }

    @Override
    public void install() {
        if (!XTSBARecoveryManagerImple.isRecoveryManagerInitialised()) {
            XTSBARecoveryManagerImple baRecoveryManager = new XTSBARecoveryManagerImple((TxLog)_recoveryStore);
            XTSBARecoveryManager.setRecoveryManager(baRecoveryManager);
        }
        Implementations.install();
    }

    @Override
    public void uninstall() {
        Implementations.uninstall();
    }

    public void periodicWorkFirstPass() {
        boolean ACCoordinators = false;
        InputObjectState acc_uids = new InputObjectState();
        try {
            if (RecoveryLogger.logger.isDebugEnabled()) {
                RecoveryLogger.logger.debug((Object)"BACoordinatorRecoveryModule: first pass");
            }
            ACCoordinators = _recoveryStore.allObjUids(this._transactionType, acc_uids);
        }
        catch (ObjectStoreException ex) {
            RecoveryLogger.i18NLogger.warn_coordinator_ba_BACoordinatorRecoveryModule_1(ex);
        }
        if (ACCoordinators) {
            this._transactionUidVector = this.processTransactions(acc_uids);
        }
    }

    public void periodicWorkSecondPass() {
        if (RecoveryLogger.logger.isDebugEnabled()) {
            RecoveryLogger.logger.debug((Object)"BACoordinatorRecoveryModule: Second pass");
        }
        if (this._transactionUidVector != null) {
            this.processTransactionsStatus();
        }
    }

    protected BACoordinatorRecoveryModule(String type) {
        if (RecoveryLogger.logger.isDebugEnabled()) {
            RecoveryLogger.logger.debug((Object)("BACoordinatorRecoveryModule created " + type));
        }
        if (_recoveryStore == null) {
            _recoveryStore = StoreManager.getRecoveryStore();
        }
        this._transactionStatusConnectionMgr = new TransactionStatusConnectionManager();
        this._transactionType = type;
    }

    private void doRecoverTransaction(Uid recoverUid) {
        boolean commitThisTransaction = true;
        int theStatus = this._transactionStatusConnectionMgr.getTransactionStatus(this._transactionType, recoverUid);
        boolean inFlight = this.isTransactionInMidFlight(theStatus);
        String Status2 = ActionStatus.stringForm((int)theStatus);
        if (RecoveryLogger.logger.isDebugEnabled()) {
            RecoveryLogger.logger.debug((Object)("transaction type is " + this._transactionType + " uid is " + recoverUid.toString() + "\n ActionStatus is " + Status2 + " in flight is " + inFlight));
        }
        if (!inFlight) {
            try {
                RecoveryLogger.logger.debug((Object)("jjh doing revovery here for " + String.valueOf(recoverUid)));
                RecoveryBACoordinator rcvACCoordinator = new RecoveryBACoordinator(recoverUid);
                rcvACCoordinator.replayPhase2();
            }
            catch (Exception ex) {
                RecoveryLogger.i18NLogger.warn_coordinator_ba_BACoordinatorRecoveryModule_2(recoverUid, ex);
            }
        }
    }

    private boolean isTransactionInMidFlight(int status) {
        boolean inFlight = false;
        switch (status) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                inFlight = true;
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                inFlight = false;
                break;
            }
            default: {
                inFlight = false;
            }
        }
        return inFlight;
    }

    private Vector processTransactions(InputObjectState uids) {
        Vector<Uid> uidVector = new Vector<Uid>();
        if (RecoveryLogger.logger.isDebugEnabled()) {
            RecoveryLogger.logger.debug((Object)("processing " + this._transactionType + " transactions"));
        }
        Uid NULL_UID = Uid.nullUid();
        Uid theUid = null;
        while (true) {
            try {
                theUid = UidHelper.unpackFrom((InputBuffer)uids);
            }
            catch (Exception ex) {
                break;
            }
            if (theUid.equals(NULL_UID)) break;
            if (RecoveryLogger.logger.isDebugEnabled()) {
                RecoveryLogger.logger.debug((Object)("found transaction " + String.valueOf(theUid)));
            }
            uidVector.addElement(theUid);
        }
        return uidVector;
    }

    private void processTransactionsStatus() {
        Enumeration transactionUidEnum = this._transactionUidVector.elements();
        while (transactionUidEnum.hasMoreElements()) {
            Uid currentUid = (Uid)transactionUidEnum.nextElement();
            try {
                if (_recoveryStore.currentState(currentUid, this._transactionType) == -1) continue;
                this.doRecoverTransaction(currentUid);
            }
            catch (ObjectStoreException ex) {
                RecoveryLogger.i18NLogger.warn_coordinator_ba_BACoordinatorRecoveryModule_3(currentUid, ex);
            }
        }
        XTSBARecoveryManager.getRecoveryManager().setCoordinatorRecoveryStarted();
    }
}

