/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.access.management.WritableAuthorizerConfiguration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.access.AccessAuthorizationResourceDefinition;
import org.jboss.as.domain.management.access.RbacSanityCheckOperation;
import org.jboss.dmr.ModelNode;

class AccessAuthorizationUseIdentityRolesWriteAttributeHandler
extends AbstractWriteAttributeHandler<Void> {
    private final WritableAuthorizerConfiguration writableConfiguration;

    AccessAuthorizationUseIdentityRolesWriteAttributeHandler(WritableAuthorizerConfiguration writableConfiguration) {
        this.writableConfiguration = writableConfiguration;
    }

    protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode oldValue, Resource model) throws OperationFailedException {
        boolean useIdentityRoles;
        boolean bl = useIdentityRoles = newValue.isDefined() ? newValue.asBoolean() : AccessAuthorizationResourceDefinition.USE_IDENTITY_ROLES.getDefaultValue().asBoolean();
        if (!useIdentityRoles) {
            RbacSanityCheckOperation.addOperation(context);
        }
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        if (!resolvedValue.equals(currentValue)) {
            if (!context.isBooting()) {
                return true;
            }
            AccessAuthorizationUseIdentityRolesWriteAttributeHandler.updateAuthorizer(resolvedValue, this.writableConfiguration);
        }
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        AccessAuthorizationUseIdentityRolesWriteAttributeHandler.updateAuthorizer(valueToRestore, this.writableConfiguration);
    }

    static void updateAuthorizer(ModelNode value, WritableAuthorizerConfiguration writableConfiguration) {
        ModelNode resolvedValue = value.isDefined() ? value : AccessAuthorizationResourceDefinition.USE_IDENTITY_ROLES.getDefaultValue();
        boolean useIdentityRoles = resolvedValue.asBoolean();
        writableConfiguration.setUseIdentityRoles(useIdentityRoles);
    }
}

