/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.subsystem.resource.capability;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.subsystem.resource.ResourceModelResolver;
import org.wildfly.subsystem.resource.SimpleResource;
import org.wildfly.subsystem.resource.capability.CapabilityReference;
import org.wildfly.subsystem.resource.capability.CapabilityReferenceResolver;
import org.wildfly.subsystem.service.ServiceDependency;

public class CapabilityReferenceListAttributeDefinition<T>
extends StringListAttributeDefinition
implements ResourceModelResolver<ServiceDependency<List<T>>> {
    private final CapabilityReferenceResolver<T> resolver;

    CapabilityReferenceListAttributeDefinition(Builder<T> builder) {
        super(builder);
        this.resolver = builder.resolver;
    }

    @Override
    public ServiceDependency<List<T>> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        List values = this.resolveModelAttribute(context, model).asListOrEmpty();
        if (!values.isEmpty()) {
            final ArrayList dependencies = new ArrayList(values.size());
            for (ModelNode value : values) {
                Map.Entry<String, String[]> resolved = this.resolver.resolve(context, new SimpleResource(model), value.asString());
                if (resolved == null) continue;
                dependencies.add(ServiceDependency.on(resolved.getKey(), this.resolver.getRequirement().getType(), resolved.getValue()));
            }
            if (!dependencies.isEmpty()) {
                return new ServiceDependency<List<T>>(){

                    public void accept(RequirementServiceBuilder<?> builder) {
                        for (ServiceDependency dependency : dependencies) {
                            dependency.accept(builder);
                        }
                    }

                    public List<T> get() {
                        ArrayList<Object> values = new ArrayList<Object>();
                        for (ServiceDependency dependency : dependencies) {
                            values.add(dependency.get());
                        }
                        return values;
                    }
                };
            }
        }
        return ServiceDependency.of(List.of());
    }

    public static class Builder<T>
    extends ListAttributeDefinition.Builder<Builder<T>, CapabilityReferenceListAttributeDefinition<T>> {
        final CapabilityReferenceResolver<T> resolver;

        public Builder(String attributeName, CapabilityReference<T> reference) {
            super(attributeName);
            this.setAttributeParser(AttributeParser.STRING_LIST);
            this.setAttributeMarshaller(AttributeMarshaller.STRING_LIST);
            this.setElementValidator((ParameterValidator)new ModelTypeValidator(ModelType.STRING));
            this.setAllowExpression(false);
            this.setCapabilityReference(reference);
            this.setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES});
            this.resolver = reference;
        }

        public Builder(String attributeName, CapabilityReferenceListAttributeDefinition<T> basis) {
            super(attributeName, basis);
            this.resolver = basis.resolver;
        }

        public Builder<T> setDefaultValue(ModelNode defaultValue) {
            if (defaultValue != null && defaultValue.isDefined()) {
                throw new UnsupportedOperationException();
            }
            return this;
        }

        public Builder<T> setAllowExpression(boolean allowExpression) {
            if (allowExpression) {
                throw new UnsupportedOperationException();
            }
            return this;
        }

        public CapabilityReferenceListAttributeDefinition<T> build() {
            return new CapabilityReferenceListAttributeDefinition(this);
        }
    }
}

