/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.scheduler;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Scheduler<I, V>
extends AutoCloseable {
    public void schedule(I var1, V var2);

    public void cancel(I var1);

    public boolean contains(I var1);

    @Override
    public void close();

    default public <T> Scheduler<I, T> map(final Function<T, Optional<V>> mapper) {
        return new Scheduler<I, T>(){

            @Override
            public void schedule(I id, T value) {
                Optional mapped = (Optional)mapper.apply(value);
                if (mapped.isPresent()) {
                    Scheduler.this.schedule(id, mapped.get());
                }
            }

            @Override
            public void cancel(I id) {
                Scheduler.this.cancel(id);
            }

            @Override
            public boolean contains(I id) {
                return Scheduler.this.contains(id);
            }

            @Override
            public void close() {
                Scheduler.this.close();
            }
        };
    }

    public static <I, V> Scheduler<I, V> inactive() {
        return new InactiveScheduler();
    }

    public static <I, V> Scheduler<I, V> fromReference(Supplier<? extends Scheduler<I, V>> reference) {
        return new ReferenceScheduler(reference);
    }

    public static class InactiveScheduler<I, V>
    implements Scheduler<I, V> {
        protected InactiveScheduler() {
        }

        @Override
        public void schedule(I id, V value) {
        }

        @Override
        public void cancel(I id) {
        }

        @Override
        public boolean contains(I id) {
            return false;
        }

        @Override
        public void close() {
        }
    }

    public static class ReferenceScheduler<I, V>
    implements Scheduler<I, V> {
        private final Supplier<? extends Scheduler<I, V>> reference;

        protected ReferenceScheduler(Supplier<? extends Scheduler<I, V>> reference) {
            this.reference = reference;
        }

        @Override
        public void schedule(I id, V metaData) {
            this.reference.get().schedule(id, metaData);
        }

        @Override
        public void cancel(I id) {
            this.reference.get().cancel(id);
        }

        @Override
        public boolean contains(I id) {
            return this.reference.get().contains(id);
        }

        @Override
        public void close() {
            this.reference.get().close();
        }
    }
}

