/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.io.IOException;
import java.util.Comparator;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.function.Function;
import org.wildfly.clustering.function.Supplier;
import org.wildfly.clustering.marshalling.protostream.FieldSetMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public enum ComparatorMarshaller implements FieldSetMarshaller.Simple<Comparator<?>>
{
    INSTANCE;

    private static final int REVERSE_INDEX = 0;
    private static final int COMPARATOR_INDEX = 1;
    private static final int FIELDS = 2;

    @Override
    public Comparator<?> createInitialValue() {
        return Comparator.naturalOrder();
    }

    @Override
    public int getFields() {
        return 2;
    }

    @Override
    public Comparator<?> readFrom(ProtoStreamReader reader, int index, WireType type, Comparator<?> comparator) throws IOException {
        return switch (index) {
            case 0 -> {
                if (reader.readBool()) {
                    yield Comparator.reverseOrder();
                }
                yield Comparator.naturalOrder();
            }
            case 1 -> reader.readAny(Comparator.class);
            default -> (Comparator)Supplier.call(() -> reader.skipField(type), null).thenApply((java.util.function.Function)Function.of(comparator)).get();
        };
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, Comparator<?> comparator) throws IOException {
        boolean reverse;
        boolean natural = comparator == Comparator.naturalOrder();
        boolean bl = reverse = comparator == Comparator.reverseOrder();
        if (natural || reverse) {
            writer.writeBool(0, reverse);
        } else {
            writer.writeAny(1, comparator);
        }
    }
}

