/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.metadata.ear.spec.EarMetaData;
import org.jboss.metadata.ear.spec.ModuleMetaData;
import org.jboss.metadata.ear.spec.ModulesMetaData;
import org.jboss.metadata.ear.spec.WebModuleMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;

public class EarContextRootProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData == null) {
            return;
        }
        ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        if (deploymentRoot == null) {
            return;
        }
        DeploymentUnit parent = deploymentUnit.getParent();
        if (parent == null || !DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)parent)) {
            return;
        }
        EarMetaData earMetaData = (EarMetaData)parent.getAttachment(org.jboss.as.ee.structure.Attachments.EAR_METADATA);
        if (earMetaData == null) {
            return;
        }
        ModulesMetaData modulesMetaData = earMetaData.getModules();
        if (modulesMetaData != null) {
            for (ModuleMetaData moduleMetaData : modulesMetaData) {
                if (!ModuleMetaData.ModuleType.Web.equals((Object)moduleMetaData.getType()) || !moduleMetaData.getFileName().equals(deploymentRoot.getRootName())) continue;
                Object contextRoot = ((WebModuleMetaData)WebModuleMetaData.class.cast(moduleMetaData.getValue())).getContextRoot();
                if (contextRoot == null && (warMetaData.getJBossWebMetaData() == null || warMetaData.getJBossWebMetaData().getContextRoot() == null)) {
                    contextRoot = "/" + parent.getName().substring(0, parent.getName().length() - 4) + "/" + deploymentUnit.getName().substring(0, deploymentUnit.getName().length() - 4);
                }
                if (contextRoot != null) {
                    JBossWebMetaData jBossWebMetaData = warMetaData.getJBossWebMetaData();
                    if (jBossWebMetaData == null) {
                        jBossWebMetaData = new JBossWebMetaData();
                        warMetaData.setJBossWebMetaData(jBossWebMetaData);
                    }
                    jBossWebMetaData.setContextRoot((String)contextRoot);
                }
                return;
            }
        }
    }
}

