/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.ejb3.remote.AssociationService;
import org.jboss.as.ejb3.remote.RemotingProfileService;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.discovery.Discovery;
import org.wildfly.discovery.impl.StaticDiscoveryProvider;
import org.wildfly.discovery.spi.DiscoveryProvider;

public final class DiscoveryService
implements Service {
    private static final DiscoveryProvider[] NO_PROVIDERS = new DiscoveryProvider[0];
    public static final ServiceName BASE_NAME = ServiceName.JBOSS.append(new String[]{"deployment", "discovery"});
    private final Collection<DiscoveryProvider> providers = new LinkedHashSet<DiscoveryProvider>();
    private final Consumer<Discovery> discoveryConsumer;
    private final Supplier<RemotingProfileService> remotingProfileServiceSupplier;
    private final Supplier<AssociationService> associationServiceSupplier;
    private volatile DiscoveryProvider remotingDP;
    private volatile DiscoveryProvider assocationDP;

    public DiscoveryService(Consumer<Discovery> discoveryConsumer, Supplier<RemotingProfileService> remotingProfileServiceSupplier, Supplier<AssociationService> associationServiceSupplier) {
        this.discoveryConsumer = discoveryConsumer;
        this.remotingProfileServiceSupplier = remotingProfileServiceSupplier;
        this.associationServiceSupplier = associationServiceSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext context) throws StartException {
        DiscoveryProvider[] providersArray;
        AssociationService associationService;
        RemotingProfileService remotingProfileService = this.remotingProfileServiceSupplier != null ? this.remotingProfileServiceSupplier.get() : null;
        AssociationService associationService2 = associationService = this.associationServiceSupplier != null ? this.associationServiceSupplier.get() : null;
        if (remotingProfileService != null) {
            this.remotingDP = new StaticDiscoveryProvider(remotingProfileService.getServiceUrls());
        }
        if (associationService != null) {
            this.assocationDP = associationService.getLocalDiscoveryProvider();
        }
        Collection<DiscoveryProvider> collection = this.providers;
        synchronized (collection) {
            if (this.remotingDP != null) {
                this.providers.add(this.remotingDP);
            }
            if (this.assocationDP != null) {
                this.providers.add(this.assocationDP);
            }
            providersArray = this.providers.toArray(NO_PROVIDERS);
        }
        this.discoveryConsumer.accept(Discovery.create((DiscoveryProvider[])providersArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(StopContext context) {
        this.discoveryConsumer.accept(null);
        Collection<DiscoveryProvider> collection = this.providers;
        synchronized (collection) {
            if (this.remotingDP != null) {
                this.providers.remove(this.remotingDP);
                this.remotingDP = null;
            }
            if (this.assocationDP != null) {
                this.providers.remove(this.assocationDP);
                this.assocationDP = null;
            }
        }
    }

    Consumer<DiscoveryProvider> getDiscoveryProviderConsumer() {
        return new Consumer<DiscoveryProvider>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(DiscoveryProvider discoveryProvider) {
                Collection<DiscoveryProvider> collection = DiscoveryService.this.providers;
                synchronized (collection) {
                    DiscoveryService.this.providers.add(discoveryProvider);
                }
            }
        };
    }
}

