/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent.deployers;

import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.deployers.AbstractPlatformBindingProcessor;
import org.jboss.as.server.deployment.DeploymentUnit;

public class EEConcurrentDefaultBindingProcessor
extends AbstractPlatformBindingProcessor {
    public static final String DEFAULT_CONTEXT_SERVICE_JNDI_NAME = "DefaultContextService";
    public static final String COMP_DEFAULT_CONTEXT_SERVICE_JNDI_NAME = "java:comp/DefaultContextService";
    public static final String DEFAULT_MANAGED_EXECUTOR_SERVICE_JNDI_NAME = "DefaultManagedExecutorService";
    public static final String COMP_DEFAULT_MANAGED_EXECUTOR_SERVICE_JNDI_NAME = "java:comp/DefaultManagedExecutorService";
    public static final String DEFAULT_MANAGED_SCHEDULED_EXECUTOR_SERVICE_JNDI_NAME = "DefaultManagedScheduledExecutorService";
    public static final String COMP_DEFAULT_MANAGED_SCHEDULED_EXECUTOR_SERVICE_JNDI_NAME = "java:comp/DefaultManagedScheduledExecutorService";
    public static final String DEFAULT_MANAGED_THREAD_FACTORY_JNDI_NAME = "DefaultManagedThreadFactory";
    public static final String COMP_DEFAULT_MANAGED_THREAD_FACTORY_JNDI_NAME = "java:comp/DefaultManagedThreadFactory";

    protected void addBindings(DeploymentUnit deploymentUnit, EEModuleDescription moduleDescription) {
        String managedThreadFactory;
        String managedScheduledExecutorService;
        String managedExecutorService;
        String contextService = moduleDescription.getDefaultResourceJndiNames().getContextService();
        if (contextService != null) {
            this.addBinding(contextService, DEFAULT_CONTEXT_SERVICE_JNDI_NAME, deploymentUnit, moduleDescription);
        }
        if ((managedExecutorService = moduleDescription.getDefaultResourceJndiNames().getManagedExecutorService()) != null) {
            this.addBinding(managedExecutorService, DEFAULT_MANAGED_EXECUTOR_SERVICE_JNDI_NAME, deploymentUnit, moduleDescription);
        }
        if ((managedScheduledExecutorService = moduleDescription.getDefaultResourceJndiNames().getManagedScheduledExecutorService()) != null) {
            this.addBinding(managedScheduledExecutorService, DEFAULT_MANAGED_SCHEDULED_EXECUTOR_SERVICE_JNDI_NAME, deploymentUnit, moduleDescription);
        }
        if ((managedThreadFactory = moduleDescription.getDefaultResourceJndiNames().getManagedThreadFactory()) != null) {
            this.addBinding(managedThreadFactory, DEFAULT_MANAGED_THREAD_FACTORY_JNDI_NAME, deploymentUnit, moduleDescription);
        }
    }
}

