/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.service;

import com.arjuna.ats.arjuna.common.RecoveryEnvironmentBean;
import com.arjuna.ats.arjuna.common.recoveryPropertyManager;
import com.arjuna.ats.internal.arjuna.recovery.AtomicActionRecoveryModule;
import com.arjuna.ats.internal.arjuna.recovery.ExpiredTransactionStatusManagerScanner;
import com.arjuna.ats.internal.jta.recovery.arjunacore.CommitMarkableResourceRecordRecoveryModule;
import com.arjuna.ats.internal.jta.recovery.arjunacore.SubordinateAtomicActionRecoveryModule;
import com.arjuna.ats.internal.jta.recovery.jts.JCAServerTransactionRecoveryModule;
import com.arjuna.ats.internal.jta.recovery.jts.XARecoveryModule;
import com.arjuna.ats.internal.jts.orbspecific.recovery.RecoveryEnablement;
import com.arjuna.ats.internal.jts.recovery.contact.ExpiredContactScanner;
import com.arjuna.ats.internal.jts.recovery.transactions.ExpiredServerScanner;
import com.arjuna.ats.internal.jts.recovery.transactions.ExpiredToplevelScanner;
import com.arjuna.ats.internal.jts.recovery.transactions.ServerTransactionRecoveryModule;
import com.arjuna.ats.internal.jts.recovery.transactions.TopLevelTransactionRecoveryModule;
import com.arjuna.ats.internal.txoj.recovery.TORecoveryModule;
import com.arjuna.ats.jbossatx.jta.RecoveryManagerService;
import com.arjuna.orbportability.internal.utils.PostInitLoader;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.ProcessStateNotifier;
import org.jboss.as.network.ManagedBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.server.suspend.ServerActivity;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.as.txn.logging.TransactionLogger;
import org.jboss.as.txn.suspend.RecoverySuspendController;
import org.jboss.msc.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.omg.CORBA.ORB;

public class ArjunaRecoveryManagerService
implements Service {
    private final Consumer<RecoveryManagerService> consumer;
    private final Supplier<ORB> orbSupplier;
    private final Supplier<SocketBinding> recoveryBindingSupplier;
    private final Supplier<SocketBinding> statusBindingSupplier;
    private final Supplier<SuspendController> suspendControllerSupplier;
    private final Supplier<ProcessStateNotifier> processStateSupplier;
    private RecoveryManagerService recoveryManagerService;
    private RecoverySuspendController recoverySuspendController;
    private boolean recoveryListener;
    private final boolean jts;
    private final Supplier<SocketBindingManager> bindingManagerSupplier;

    public ArjunaRecoveryManagerService(Consumer<RecoveryManagerService> consumer, Supplier<SocketBinding> recoveryBindingSupplier, Supplier<SocketBinding> statusBindingSupplier, Supplier<SocketBindingManager> bindingManagerSupplier, Supplier<SuspendController> suspendControllerSupplier, Supplier<ProcessStateNotifier> processStateSupplier, Supplier<ORB> orbSupplier, boolean recoveryListener, boolean jts) {
        this.consumer = consumer;
        this.recoveryBindingSupplier = recoveryBindingSupplier;
        this.statusBindingSupplier = statusBindingSupplier;
        this.suspendControllerSupplier = suspendControllerSupplier;
        this.bindingManagerSupplier = bindingManagerSupplier;
        this.processStateSupplier = processStateSupplier;
        this.recoveryListener = recoveryListener;
        this.orbSupplier = orbSupplier;
        this.jts = jts;
    }

    public void start(StartContext context) throws StartException {
        ArrayList<String> expiryScanners;
        RecoveryEnvironmentBean recoveryEnvironmentBean = recoveryPropertyManager.getRecoveryEnvironmentBean();
        SocketBinding recoveryBinding = this.recoveryBindingSupplier.get();
        recoveryEnvironmentBean.setRecoveryInetAddress(recoveryBinding.getSocketAddress().getAddress());
        recoveryEnvironmentBean.setRecoveryPort(recoveryBinding.getSocketAddress().getPort());
        SocketBinding statusBinding = this.statusBindingSupplier.get();
        recoveryEnvironmentBean.setTransactionStatusManagerInetAddress(statusBinding.getSocketAddress().getAddress());
        recoveryEnvironmentBean.setTransactionStatusManagerPort(statusBinding.getSocketAddress().getPort());
        recoveryEnvironmentBean.setRecoveryListener(this.recoveryListener);
        if (this.recoveryListener) {
            ManagedBinding binding = ManagedBinding.Factory.createSimpleManagedBinding((SocketBinding)recoveryBinding);
            this.bindingManagerSupplier.get().getNamedRegistry().registerBinding(binding);
        }
        ArrayList<String> recoveryExtensions = new ArrayList<String>();
        recoveryExtensions.add(CommitMarkableResourceRecordRecoveryModule.class.getName());
        recoveryExtensions.add(AtomicActionRecoveryModule.class.getName());
        recoveryExtensions.add(TORecoveryModule.class.getName());
        recoveryExtensions.add(SubordinateAtomicActionRecoveryModule.class.getName());
        if (System.getProperty("RecoveryEnvironmentBean.expiryScannerClassNames") != null || System.getProperty("com.arjuna.ats.arjuna.common.RecoveryEnvironmentBean.expiryScannerClassNames") != null) {
            expiryScanners = recoveryEnvironmentBean.getExpiryScannerClassNames();
        } else {
            expiryScanners = new ArrayList<String>();
            expiryScanners.add(ExpiredTransactionStatusManagerScanner.class.getName());
        }
        if (!this.jts) {
            recoveryExtensions.add(com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule.class.getName());
            recoveryEnvironmentBean.setRecoveryModuleClassNames(recoveryExtensions);
            recoveryEnvironmentBean.setExpiryScannerClassNames(expiryScanners);
            recoveryEnvironmentBean.setRecoveryActivators(null);
            RecoveryManagerService recoveryManagerService = new RecoveryManagerService();
            try {
                recoveryManagerService.create();
            }
            catch (Exception e) {
                throw TransactionLogger.ROOT_LOGGER.managerStartFailure(e, "Recovery");
            }
            recoveryManagerService.start();
            this.recoveryManagerService = recoveryManagerService;
        } else {
            ORB orb = this.orbSupplier.get();
            new PostInitLoader(PostInitLoader.generateORBPropertyName((String)"com.arjuna.orbportability.orb"), (Object)orb);
            recoveryExtensions.add(TopLevelTransactionRecoveryModule.class.getName());
            recoveryExtensions.add(ServerTransactionRecoveryModule.class.getName());
            recoveryExtensions.add(JCAServerTransactionRecoveryModule.class.getName());
            recoveryExtensions.add(XARecoveryModule.class.getName());
            expiryScanners.add(ExpiredContactScanner.class.getName());
            expiryScanners.add(ExpiredToplevelScanner.class.getName());
            expiryScanners.add(ExpiredServerScanner.class.getName());
            recoveryEnvironmentBean.setRecoveryModuleClassNames(recoveryExtensions);
            recoveryEnvironmentBean.setExpiryScannerClassNames(expiryScanners);
            recoveryEnvironmentBean.setRecoveryActivatorClassNames(Collections.singletonList(RecoveryEnablement.class.getName()));
            try {
                com.arjuna.ats.jbossatx.jts.RecoveryManagerService recoveryManagerService = new com.arjuna.ats.jbossatx.jts.RecoveryManagerService(orb);
                recoveryManagerService.create();
                recoveryManagerService.start();
                this.recoveryManagerService = recoveryManagerService;
            }
            catch (Exception e) {
                throw TransactionLogger.ROOT_LOGGER.managerStartFailure(e, "Recovery");
            }
        }
        this.recoverySuspendController = new RecoverySuspendController(this.recoveryManagerService);
        this.processStateSupplier.get().addPropertyChangeListener((PropertyChangeListener)this.recoverySuspendController);
        this.suspendControllerSupplier.get().registerActivity((ServerActivity)this.recoverySuspendController);
        this.consumer.accept(this.recoveryManagerService);
    }

    public void stop(StopContext context) {
        this.consumer.accept(null);
        this.suspendControllerSupplier.get().unRegisterActivity((ServerActivity)this.recoverySuspendController);
        this.processStateSupplier.get().removePropertyChangeListener((PropertyChangeListener)this.recoverySuspendController);
        try {
            this.recoveryManagerService.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.recoveryManagerService.destroy();
        this.recoveryManagerService = null;
        this.recoverySuspendController = null;
    }
}

