/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.installationmanager;

import java.nio.file.Path;
import java.util.Objects;

public class FileConflict {
    private Path relativePath;
    private Status userChanges;
    private Status updateChanges;
    private boolean overwritten;

    public FileConflict(Path relativePath, Status userChanges, Status updateChanges, boolean overwritten) {
        this.relativePath = relativePath;
        this.userChanges = userChanges;
        this.updateChanges = updateChanges;
        this.overwritten = overwritten;
    }

    public Path getRelativePath() {
        return this.relativePath;
    }

    public Status getUserChanges() {
        return this.userChanges;
    }

    public Status getUpdateChanges() {
        return this.updateChanges;
    }

    public boolean isOverwritten() {
        return this.overwritten;
    }

    public String toString() {
        return "FileConflict{relativePath=" + String.valueOf(this.relativePath) + ", userChanges=" + String.valueOf((Object)this.userChanges) + ", updateChanges=" + String.valueOf((Object)this.updateChanges) + ", overwritten=" + this.overwritten + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileConflict that = (FileConflict)o;
        return this.overwritten == that.overwritten && Objects.equals(this.relativePath, that.relativePath) && this.userChanges == that.userChanges && this.updateChanges == that.updateChanges;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.relativePath, this.userChanges, this.updateChanges, this.overwritten});
    }

    public static enum Status {
        MODIFIED,
        REMOVED,
        ADDED,
        NONE;

    }
}

