/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.amqp;

import io.opentelemetry.api.OpenTelemetry;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.operators.multi.processors.BroadcastProcessor;
import io.smallrye.reactive.messaging.amqp.AmqpConnectorIncomingConfiguration;
import io.smallrye.reactive.messaging.amqp.AmqpMessage;
import io.smallrye.reactive.messaging.amqp.ChannelUtils;
import io.smallrye.reactive.messaging.amqp.ConnectionHolder;
import io.smallrye.reactive.messaging.amqp.fault.AmqpAccept;
import io.smallrye.reactive.messaging.amqp.fault.AmqpFailStop;
import io.smallrye.reactive.messaging.amqp.fault.AmqpFailureHandler;
import io.smallrye.reactive.messaging.amqp.fault.AmqpModifiedFailed;
import io.smallrye.reactive.messaging.amqp.fault.AmqpModifiedFailedAndUndeliverableHere;
import io.smallrye.reactive.messaging.amqp.fault.AmqpReject;
import io.smallrye.reactive.messaging.amqp.fault.AmqpRelease;
import io.smallrye.reactive.messaging.amqp.i18n.AMQPLogging;
import io.smallrye.reactive.messaging.amqp.tracing.AmqpOpenTelemetryInstrumenter;
import io.smallrye.reactive.messaging.providers.helpers.VertxContext;
import io.vertx.amqp.AmqpReceiverOptions;
import io.vertx.core.Context;
import io.vertx.core.impl.VertxInternal;
import io.vertx.mutiny.amqp.AmqpClient;
import io.vertx.mutiny.amqp.AmqpReceiver;
import io.vertx.mutiny.core.Vertx;
import jakarta.enterprise.inject.Instance;
import java.time.Duration;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.eclipse.microprofile.reactive.messaging.Message;

public class IncomingAmqpChannel {
    private final AmqpOpenTelemetryInstrumenter amqpInstrumenter;
    private final Multi<? extends Message<?>> multi;
    private final AtomicBoolean opened;
    private final BiConsumer<String, Throwable> reportFailure;
    private final ConnectionHolder holder;

    public IncomingAmqpChannel(AmqpConnectorIncomingConfiguration ic, AmqpClient client, Vertx vertx, Instance<OpenTelemetry> openTelemetryInstance, BiConsumer<String, Throwable> reportFailure) {
        this.reportFailure = reportFailure;
        this.opened = new AtomicBoolean(false);
        String channel = ic.getChannel();
        String address = ic.getAddress().orElse(channel);
        boolean broadcast = ic.getBroadcast();
        String link = ic.getLinkName().orElse(channel);
        boolean cloudEvents = ic.getCloudEvents();
        boolean tracing = ic.getTracingEnabled();
        io.vertx.mutiny.core.Context root = io.vertx.mutiny.core.Context.newInstance((Context)((VertxInternal)vertx.getDelegate()).createEventLoopContext());
        this.holder = new ConnectionHolder(client, ic, vertx, root);
        AmqpReceiverOptions options = new AmqpReceiverOptions().setAutoAcknowledgement(ic.getAutoAcknowledgement().booleanValue()).setDurable(ic.getDurable().booleanValue()).setLinkName(link).setCapabilities(ChannelUtils.getClientCapabilities(ic)).setSelector((String)ic.getSelector().orElse(null));
        this.amqpInstrumenter = ic.getTracingEnabled() != false ? AmqpOpenTelemetryInstrumenter.createForConnector(openTelemetryInstance) : null;
        AmqpFailureHandler onNack = this.createFailureHandler(ic);
        Integer interval = ic.getRetryOnFailInterval();
        Integer attempts = ic.getRetryOnFailAttempts();
        this.multi = this.holder.getOrEstablishConnection().onItem().transformToUni(connection -> connection.createReceiver(address, options)).onItem().invoke(r -> this.opened.set(true)).onItem().transformToMulti(r -> this.getStreamOfMessages((AmqpReceiver)r, this.holder, address, channel, onNack, cloudEvents, tracing)).onFailure().invoke(AMQPLogging.log::retrieveMessagesRetrying).onFailure().retry().withBackOff(Duration.ofSeconds(1L), Duration.ofSeconds(interval.intValue())).atMost((long)attempts.intValue()).onFailure().invoke(t -> {
            this.opened.set(false);
            AMQPLogging.log.retrieveMessagesNoMoreRetrying((Throwable)t);
        }).plug(m -> broadcast ? m.broadcast().toAllSubscribers() : m);
    }

    public boolean isOpen() {
        return this.opened.get();
    }

    public ConnectionHolder getHolder() {
        return this.holder;
    }

    public Flow.Publisher<? extends Message<?>> getPublisher() {
        return this.multi;
    }

    private Multi<? extends Message<?>> getStreamOfMessages(AmqpReceiver receiver, ConnectionHolder holder, String address, String channel, AmqpFailureHandler onNack, boolean cloudEventEnabled, Boolean tracingEnabled) {
        AMQPLogging.log.receiverListeningAddress(address);
        BroadcastProcessor processor = BroadcastProcessor.create();
        receiver.exceptionHandler(t -> {
            AMQPLogging.log.receiverError((Throwable)t);
            processor.onError(t);
        });
        holder.onFailure(arg_0 -> ((BroadcastProcessor)processor).onError(arg_0));
        return Multi.createFrom().deferred(() -> {
            Multi stream = receiver.toMulti().emitOn(c -> VertxContext.runOnContext((Context)holder.getContext().getDelegate(), (Runnable)c)).onItem().transformToUniAndConcatenate(m -> {
                try {
                    return Uni.createFrom().item(new AmqpMessage((io.vertx.mutiny.amqp.AmqpMessage)m, holder.getContext(), onNack, cloudEventEnabled, tracingEnabled));
                }
                catch (Exception e) {
                    AMQPLogging.log.unableToCreateMessage(channel, e);
                    return Uni.createFrom().nullItem();
                }
            });
            if (tracingEnabled.booleanValue()) {
                stream = stream.onItem().transform(m -> this.amqpInstrumenter.traceIncoming((Message<?>)m, (AmqpMessage)m));
            }
            return Multi.createBy().merging().streams(new Flow.Publisher[]{stream, processor});
        });
    }

    private AmqpFailureHandler createFailureHandler(AmqpConnectorIncomingConfiguration config) {
        String strategy = config.getFailureStrategy();
        AmqpFailureHandler.Strategy actualStrategy = AmqpFailureHandler.Strategy.from(strategy);
        return switch (actualStrategy) {
            default -> throw new IncompatibleClassChangeError();
            case AmqpFailureHandler.Strategy.FAIL -> new AmqpFailStop(config.getChannel(), this.reportFailure);
            case AmqpFailureHandler.Strategy.ACCEPT -> new AmqpAccept(config.getChannel());
            case AmqpFailureHandler.Strategy.REJECT -> new AmqpReject(config.getChannel());
            case AmqpFailureHandler.Strategy.RELEASE -> new AmqpRelease(config.getChannel());
            case AmqpFailureHandler.Strategy.MODIFIED_FAILED -> new AmqpModifiedFailed(config.getChannel());
            case AmqpFailureHandler.Strategy.MODIFIED_FAILED_UNDELIVERABLE_HERE -> new AmqpModifiedFailedAndUndeliverableHere(config.getChannel());
        };
    }

    public Uni<Boolean> isConnected() {
        return this.holder.isConnected();
    }

    public long getHealthTimeout() {
        return this.holder.getHealthTimeout();
    }

    public void close() {
        this.opened.set(false);
    }
}

