/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.SequenceInputStream;
import java.util.List;
import java.util.Objects;
import org.jgroups.Address;
import org.jgroups.FragmentedMessage;
import org.jgroups.Message;
import org.jgroups.MessageFactory;
import org.jgroups.protocols.FRAG2;
import org.jgroups.protocols.FragHeader;
import org.jgroups.util.ByteArrayDataInputStream;
import org.jgroups.util.Range;
import org.jgroups.util.Util;

public class FRAG4
extends FRAG2 {
    @Override
    protected void fragment(Message msg) {
        try {
            if (msg.getSrc() == null && this.local_addr != null) {
                msg.setSrc(this.local_addr);
            }
            int offset = msg.hasArray() ? msg.getOffset() : 0;
            int length = msg.hasArray() ? msg.getLength() : msg.size();
            List<Range> fragments = Util.computeFragOffsets(offset, length, this.frag_size);
            int num_frags = fragments.size();
            long frag_id = this.getNextId();
            this.num_frags_sent.add(num_frags);
            if (this.log.isTraceEnabled()) {
                Address dest = msg.getDest();
                this.log.trace("%s: fragmenting message to %s (size=%d) into %d fragment(s) [frag_size=%d]", this.local_addr, dest != null ? dest : "<all>", msg.getLength(), num_frags, this.frag_size);
            }
            for (int i = 0; i < num_frags; ++i) {
                Range r = fragments.get(i);
                Message frag_msg = msg.hasArray() ? msg.copy(false, i == 0).setArray(msg.getArray(), (int)r.low, (int)r.high).putHeader(this.id, new FragHeader(frag_id, i, num_frags)) : new FragmentedMessage(msg, (int)r.low, (int)r.high).setDest(msg.getDest()).setSrc(msg.getSrc()).setFlag(msg.getFlags(true), true).setFlag(msg.getFlags(false), false).putHeader(this.id, new FragHeader(frag_id, i, num_frags).setOriginalType(msg.getType()));
                this.down_prot.down(frag_msg);
            }
        }
        catch (Exception e) {
            this.log.error("%s: fragmentation failure: %s", this.local_addr, e);
        }
    }

    @Override
    protected Message assembleMessage(Message[] fragments, boolean needs_deserialization, FragHeader hdr) throws Exception {
        if (fragments[0] instanceof FragmentedMessage) {
            if (Objects.equals(this.local_addr, fragments[0].getSrc())) {
                return ((FragmentedMessage)fragments[0]).getOriginalMessage();
            }
            SequenceInputStream seq = new SequenceInputStream(Util.enumerate(fragments, 0, fragments.length, m -> new ByteArrayDataInputStream(m.getArray(), m.getOffset(), m.getLength())));
            DataInputStream in = new DataInputStream(seq);
            Object retval = MessageFactory.create(hdr.getOriginalType());
            retval.readFrom(in);
            return retval;
        }
        int combined_length = 0;
        int index = 0;
        for (Message fragment : fragments) {
            combined_length += fragment.getLength();
        }
        byte[] combined_buffer = new byte[combined_length];
        Message retval = fragments[0].copy(false, true);
        for (int i = 0; i < fragments.length; ++i) {
            Message fragment;
            fragment = fragments[i];
            fragments[i] = null;
            byte[] tmp = fragment.getArray();
            int length = fragment.getLength();
            int offset = fragment.getOffset();
            System.arraycopy(tmp, offset, combined_buffer, index, length);
            index += length;
        }
        return retval.setArray(combined_buffer, 0, combined_buffer.length);
    }
}

