/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.smime;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.InternetHeaders;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.Providers;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.security.cert.CertificateEncodingException;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSEnvelopedDataStreamGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.operator.OutputEncryptor;
import org.jboss.resteasy.plugins.providers.ProviderHelper;
import org.jboss.resteasy.security.BouncyIntegration;
import org.jboss.resteasy.security.doseta.i18n.Messages;
import org.jboss.resteasy.security.smime.EnvelopedOutput;
import org.jboss.resteasy.security.smime.SMIMEOutput;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.spi.AsyncMessageBodyWriter;
import org.jboss.resteasy.spi.AsyncOutputStream;
import org.jboss.resteasy.spi.WriterException;
import org.jboss.resteasy.util.MediaTypeHelper;

@Provider
@Produces(value={"*/*"})
public class EnvelopedWriter
implements AsyncMessageBodyWriter<EnvelopedOutput> {
    @Context
    protected Providers providers;

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return EnvelopedOutput.class.isAssignableFrom(type) && !MediaTypeHelper.isBlacklisted((MediaType)mediaType);
    }

    public long getSize(EnvelopedOutput smimeOutput, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(EnvelopedOutput out, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException, WebApplicationException {
        try {
            os.write(this.getBytes(out, headers));
        }
        catch (Exception e) {
            throw new WriterException((Throwable)e);
        }
    }

    private byte[] getBytes(EnvelopedOutput out, MultivaluedMap<String, Object> headers) throws CMSException, CertificateEncodingException, IOException, MessagingException {
        ByteArrayOutputStream baos = null;
        OutputStream encrypted = null;
        headers.putSingle((Object)"Content-Disposition", (Object)"attachment; filename=\"smime.p7m\"");
        headers.putSingle((Object)"Content-Type", (Object)"application/pkcs7-mime; smime-type=enveloped-data; name=\"smime.p7m\"");
        headers.putSingle((Object)"Content-Transfer-Encoding", (Object)"base64");
        OutputEncryptor encryptor = new JceCMSContentEncryptorBuilder(CMSAlgorithm.DES_EDE3_CBC).setProvider("BC").build();
        if (out.getCertificate() == null) {
            throw new NullPointerException(Messages.MESSAGES.certificateObjectNotSet());
        }
        JceKeyTransRecipientInfoGenerator infoGenerator = new JceKeyTransRecipientInfoGenerator(out.getCertificate());
        infoGenerator.setProvider("BC");
        CMSEnvelopedDataStreamGenerator generator = new CMSEnvelopedDataStreamGenerator();
        generator.addRecipientInfoGenerator((RecipientInfoGenerator)infoGenerator);
        MimeBodyPart _msg = EnvelopedWriter.createBodyPart(this.providers, out);
        baos = new ByteArrayOutputStream();
        encrypted = generator.open((OutputStream)baos, encryptor);
        _msg.writeTo(encrypted);
        encrypted.close();
        byte[] bytes = baos.toByteArray();
        String str = Base64.getMimeEncoder().encodeToString(bytes);
        return str.getBytes();
    }

    public CompletionStage<Void> asyncWriteTo(EnvelopedOutput out, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, AsyncOutputStream entityStream) {
        try {
            return entityStream.asyncWrite(this.getBytes(out, httpHeaders));
        }
        catch (Exception e) {
            return ProviderHelper.completedException((Throwable)new WriterException((Throwable)e));
        }
    }

    public static MimeBodyPart createBodyPart(Providers providers, SMIMEOutput out) throws IOException, MessagingException {
        ByteArrayOutputStream bodyOs = new ByteArrayOutputStream();
        MessageBodyWriter writer = providers.getMessageBodyWriter(out.getType(), out.getGenericType(), null, out.getMediaType());
        if (writer == null) {
            throw new WriterException(Messages.MESSAGES.failedToFindWriter(out.getType().getName()));
        }
        MultivaluedMapImpl bodyHeaders = new MultivaluedMapImpl();
        bodyHeaders.add((Object)"Content-Type", (Object)out.getMediaType().toString());
        writer.writeTo(out.getEntity(), out.getType(), out.getGenericType(), null, out.getMediaType(), (MultivaluedMap)bodyHeaders, (OutputStream)bodyOs);
        InternetHeaders ih = new InternetHeaders();
        for (Map.Entry entry : bodyHeaders.entrySet()) {
            for (Object value : (List)entry.getValue()) {
                ih.addHeader((String)entry.getKey(), value.toString());
            }
        }
        return new MimeBodyPart(ih, bodyOs.toByteArray());
    }

    static {
        BouncyIntegration.init();
    }
}

