/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.AbstractMap;
import java.util.Map;
import java.util.function.Predicate;
import org.wildfly.clustering.function.BiFunction;
import org.wildfly.clustering.function.Supplier;

public interface Function<T, R>
extends java.util.function.Function<T, R> {
    public static final Function<?, ?> IDENTITY = value -> value;
    public static final Function<?, ?> NULL = value -> null;

    @Override
    default public <V> Function<V, R> compose(final java.util.function.Function<? super V, ? extends T> before) {
        return new Function<V, R>(){

            @Override
            public R apply(V value) {
                return Function.this.apply(before.apply(value));
            }
        };
    }

    default public <V1, V2> BiFunction<V1, V2, R> compose(final BiFunction<V1, V2, T> mapper) {
        return new BiFunction<V1, V2, R>(){

            @Override
            public R apply(V1 value1, V2 value2) {
                return Function.this.apply(mapper.apply(value1, value2));
            }
        };
    }

    @Override
    default public <V> Function<T, V> andThen(final java.util.function.Function<? super R, ? extends V> after) {
        return new Function<T, V>(){

            @Override
            public V apply(T value) {
                return after.apply(Function.this.apply(value));
            }
        };
    }

    default public Function<T, R> withDefault(final Predicate<T> predicate, final java.util.function.Supplier<T> defaultValue) {
        return new Function<T, R>(){

            @Override
            public R apply(T value) {
                return Function.this.apply(predicate.test(value) ? value : defaultValue.get());
            }
        };
    }

    default public Function<T, R> orDefault(final Predicate<T> predicate, final java.util.function.Supplier<R> defaultResult) {
        return new Function<T, R>(){

            @Override
            public R apply(T value) {
                return predicate.test(value) ? Function.this.apply(value) : defaultResult.get();
            }
        };
    }

    default public Function<T, R> handle(final java.util.function.BiFunction<T, RuntimeException, R> handler) {
        return new Function<T, R>(){

            @Override
            public R apply(T value) {
                try {
                    return Function.this.apply(value);
                }
                catch (RuntimeException e) {
                    return handler.apply(value, e);
                }
            }
        };
    }

    public static <T extends R, R> Function<T, R> identity() {
        return IDENTITY;
    }

    public static <T, R> Function<T, R> empty() {
        return NULL;
    }

    public static <T, R> Function<T, R> of(final R result) {
        return result != null ? new Function<T, R>(){

            @Override
            public R apply(T ignore) {
                return result;
            }
        } : Function.empty();
    }

    public static <T, R> Function<T, R> get(final java.util.function.Supplier<R> supplier) {
        return supplier != null && supplier != Supplier.NULL ? new Function<T, R>(){

            @Override
            public R apply(T ignore) {
                return supplier.get();
            }
        } : Function.empty();
    }

    public static <K, V, KR, VR> Function<Map.Entry<K, V>, Map.Entry<KR, VR>> entry(final Function<K, KR> keyFunction, final Function<V, VR> valueFunction) {
        return new Function<Map.Entry<K, V>, Map.Entry<KR, VR>>(){

            @Override
            public Map.Entry<KR, VR> apply(Map.Entry<K, V> entry) {
                return new AbstractMap.SimpleImmutableEntry(keyFunction.apply(entry.getKey()), valueFunction.apply(entry.getValue()));
            }
        };
    }
}

