/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.subsystem;

import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.ee.concurrent.ConcurrencyImplementation;
import org.jboss.as.ee.subsystem.Attribute;
import org.jboss.as.ee.subsystem.DefaultBindingsResourceDefinition;
import org.jboss.as.ee.subsystem.EeSubsystemRootResource;
import org.jboss.as.ee.subsystem.Element;
import org.jboss.as.ee.subsystem.GlobalDirectoryResourceDefinition;
import org.jboss.as.ee.subsystem.GlobalModulesDefinition;
import org.jboss.as.ee.subsystem.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

class EESubsystemXmlPersister
implements XMLStreamConstants,
XMLElementWriter<SubsystemMarshallingContext> {
    public static final EESubsystemXmlPersister INSTANCE = new EESubsystemXmlPersister();

    private EESubsystemXmlPersister() {
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode eeSubSystem = context.getModelNode();
        GlobalModulesDefinition.INSTANCE.marshallAsElement(eeSubSystem, (XMLStreamWriter)writer);
        this.writeGlobalDirectoryElement(writer, eeSubSystem);
        EeSubsystemRootResource.EAR_SUBDEPLOYMENTS_ISOLATED.marshallAsElement(eeSubSystem, (XMLStreamWriter)writer);
        EeSubsystemRootResource.SPEC_DESCRIPTOR_PROPERTY_REPLACEMENT.marshallAsElement(eeSubSystem, (XMLStreamWriter)writer);
        EeSubsystemRootResource.JBOSS_DESCRIPTOR_PROPERTY_REPLACEMENT.marshallAsElement(eeSubSystem, (XMLStreamWriter)writer);
        EeSubsystemRootResource.ANNOTATION_PROPERTY_REPLACEMENT.marshallAsElement(eeSubSystem, (XMLStreamWriter)writer);
        ConcurrencyImplementation.INSTANCE.writeConcurrentElement(writer, eeSubSystem);
        this.writeDefaultBindingsElement(writer, eeSubSystem);
        writer.writeEndElement();
    }

    private void writeDefaultBindingsElement(XMLExtendedStreamWriter writer, ModelNode eeSubSystem) throws XMLStreamException {
        if (eeSubSystem.hasDefined("service") && eeSubSystem.get("service").hasDefined("default-bindings")) {
            ModelNode defaultBindingsNode = eeSubSystem.get(new String[]{"service", "default-bindings"});
            writer.writeStartElement(Element.DEFAULT_BINDINGS.getLocalName());
            for (SimpleAttributeDefinition ad : DefaultBindingsResourceDefinition.ATTRIBUTES) {
                ad.marshallAsAttribute(defaultBindingsNode, (XMLStreamWriter)writer);
            }
            writer.writeEndElement();
        }
    }

    private void writeGlobalDirectoryElement(XMLExtendedStreamWriter writer, ModelNode eeSubSystem) throws XMLStreamException {
        if (eeSubSystem.hasDefined("global-directory")) {
            writer.writeStartElement(Element.GLOBAL_DIRECTORIES.getLocalName());
            this.writeDirectoryElement(writer, eeSubSystem.get("global-directory"));
            writer.writeEndElement();
        }
    }

    private void writeDirectoryElement(XMLExtendedStreamWriter writer, ModelNode subModel) throws XMLStreamException {
        for (Property property : subModel.asPropertyList()) {
            writer.writeStartElement(Element.DIRECTORY.getLocalName());
            writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
            for (SimpleAttributeDefinition ad : GlobalDirectoryResourceDefinition.ATTRIBUTES) {
                ad.marshallAsAttribute(property.getValue(), (XMLStreamWriter)writer);
            }
            writer.writeEndElement();
        }
    }
}

