/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.selector.filter;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.selector.filter.Expression;
import org.apache.activemq.artemis.selector.filter.FilterException;
import org.apache.activemq.artemis.selector.filter.Filterable;

public class PropertyExpression
implements Expression {
    private final SimpleString name;

    public PropertyExpression(String name) {
        this(SimpleString.of(name));
    }

    public PropertyExpression(SimpleString name) {
        this.name = name;
    }

    @Override
    public Object evaluate(Filterable message) throws FilterException {
        return message.getProperty(this.name);
    }

    public String getName() {
        return this.name.toString();
    }

    public String toString() {
        return this.name.toString();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PropertyExpression)) {
            return false;
        }
        PropertyExpression other = (PropertyExpression)obj;
        return Objects.equals(this.name, other.name);
    }
}

