/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.ejb;

import io.undertow.conduits.GzipStreamSourceConduit;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.AllowedMethodsHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.encoding.ContentEncodingRepository;
import io.undertow.server.handlers.encoding.EncodingHandler;
import io.undertow.server.handlers.encoding.GzipEncodingProvider;
import io.undertow.server.handlers.encoding.RequestEncodingHandler;
import io.undertow.util.Headers;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.jboss.ejb.server.Association;
import org.wildfly.httpclient.common.HttpServiceConfig;
import org.wildfly.httpclient.ejb.RequestType;
import org.wildfly.httpclient.ejb.ServerHandlers;
import org.wildfly.transaction.client.LocalTransactionContext;

public class HttpRemoteEjbService {
    private final HttpServiceConfig config;
    private final ServerHandlers serverHandlers;

    public HttpRemoteEjbService(Association association, ExecutorService executorService, LocalTransactionContext localTransactionContext, Function<String, Boolean> classResolverFilter) {
        this(HttpServiceConfig.getInstance(), association, executorService, localTransactionContext, classResolverFilter);
    }

    protected HttpRemoteEjbService(HttpServiceConfig config, Association association, ExecutorService executorService, LocalTransactionContext localTransactionContext, Function<String, Boolean> classResolverFilter) {
        this.config = config;
        this.serverHandlers = ServerHandlers.newInstance(config, association, executorService, localTransactionContext, classResolverFilter);
    }

    public HttpHandler createHttpHandler() {
        PathHandler pathHandler = new PathHandler();
        for (RequestType requestType : RequestType.values()) {
            this.registerHandler(pathHandler, requestType);
        }
        EncodingHandler encodingHandler = new EncodingHandler(pathHandler, new ContentEncodingRepository().addEncodingHandler(Headers.GZIP.toString(), new GzipEncodingProvider(), 1));
        RequestEncodingHandler requestEncodingHandler = new RequestEncodingHandler(encodingHandler);
        requestEncodingHandler.addEncoding(Headers.GZIP.toString(), GzipStreamSourceConduit.WRAPPER);
        return this.config.wrap(requestEncodingHandler);
    }

    private void registerHandler(PathHandler pathHandler, RequestType requestType) {
        pathHandler.addPrefixPath(requestType.getPath(), new AllowedMethodsHandler(this.serverHandlers.handlerOf(requestType), requestType.getMethod()));
    }
}

