/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.soteria.original;

import jakarta.annotation.Priority;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import jakarta.security.auth.message.callback.CallerPrincipalCallback;
import jakarta.security.enterprise.AuthenticationStatus;
import jakarta.security.enterprise.authentication.mechanism.http.AutoApplySession;
import jakarta.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.Principal;
import javax.security.auth.callback.Callback;
import org.glassfish.soteria.Utils;

@Interceptor
@AutoApplySession
@Priority(value=200)
public class AutoApplySessionInterceptor
implements Serializable {
    private static final long serialVersionUID = 1L;

    @AroundInvoke
    public Object intercept(InvocationContext invocationContext) throws Exception {
        if (Utils.isImplementationOf((Method)invocationContext.getMethod(), (Method)Utils.validateRequestMethod)) {
            HttpMessageContext httpMessageContext = (HttpMessageContext)invocationContext.getParameters()[2];
            Principal userPrincipal = this.getPrincipal(httpMessageContext.getRequest());
            if (userPrincipal != null) {
                httpMessageContext.getHandler().handle(new Callback[]{new CallerPrincipalCallback(httpMessageContext.getClientSubject(), userPrincipal)});
                return AuthenticationStatus.SUCCESS;
            }
            Object outcome = invocationContext.proceed();
            if (AuthenticationStatus.SUCCESS.equals(outcome)) {
                httpMessageContext.getMessageInfo().getMap().put("jakarta.servlet.http.registerSession", Boolean.TRUE.toString());
            }
            return outcome;
        }
        return invocationContext.proceed();
    }

    private Principal getPrincipal(HttpServletRequest request) {
        return request.getUserPrincipal();
    }
}

