/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.apache.activemq.artemis.api.core.management.BaseBroadcastGroupControl;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.messaging.activemq.AbstractActiveMQComponentControlHandler;
import org.wildfly.extension.messaging.activemq.ActiveMQBroker;

public class BroadcastGroupControlHandler
extends AbstractActiveMQComponentControlHandler<BaseBroadcastGroupControl> {
    public static final BroadcastGroupControlHandler INSTANCE = new BroadcastGroupControlHandler();

    private BroadcastGroupControlHandler() {
    }

    @Override
    protected BaseBroadcastGroupControl getActiveMQComponentControl(ActiveMQBroker activeMQBroker, PathAddress address) {
        String resourceName = address.getLastElement().getValue();
        return (BaseBroadcastGroupControl)BaseBroadcastGroupControl.class.cast(activeMQBroker.getResource("broadcastgroup." + resourceName));
    }

    @Override
    protected String getDescriptionPrefix() {
        return "broadcast-group";
    }

    @Override
    protected Object handleOperation(String operationName, OperationContext context, ModelNode operation) throws OperationFailedException {
        if ("get-connector-pairs-as-json".equals(operationName)) {
            BaseBroadcastGroupControl control = (BaseBroadcastGroupControl)this.getActiveMQComponentControl(context, operation, false);
            try {
                if (control != null) {
                    context.getResult().set(control.getConnectorPairsAsJSON());
                }
            }
            catch (Exception e) {
                context.getFailureDescription().set(e.getLocalizedMessage());
            }
        } else {
            this.unsupportedOperation(operationName);
        }
        return null;
    }
}

