/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.opentracing;

import java.util.Collections;
import java.util.Set;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceXMLParser;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.extension.AbstractLegacyExtension;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.wildfly.extension.microprofile.opentracing.SubsystemDefinition;
import org.wildfly.extension.microprofile.opentracing.SubsytemParser_1_0;
import org.wildfly.extension.microprofile.opentracing.SubsytemParser_2_0;
import org.wildfly.extension.microprofile.opentracing.SubsytemParser_3_0;
import org.wildfly.extension.microprofile.opentracing.TracingDeploymentDefinition;

public class SubsystemExtension
extends AbstractLegacyExtension {
    public static final String SUBSYSTEM_NAME = "microprofile-opentracing-smallrye";
    public static final String EXTENSION_NAME = "org.wildfly.extension.microprofile.opentracing-smallrye";
    protected static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"microprofile-opentracing-smallrye");
    private static final String RESOURCE_NAME = SubsystemExtension.class.getPackage().getName() + ".LocalDescriptions";
    protected static final ModelVersion VERSION_1_0_0 = ModelVersion.create((int)1, (int)0, (int)0);
    protected static final ModelVersion VERSION_2_0_0 = ModelVersion.create((int)2, (int)0, (int)0);
    protected static final ModelVersion VERSION_3_0_0;
    private static final ModelVersion CURRENT_MODEL_VERSION;
    private static final PersistentResourceXMLParser PARSER;
    public static final String NAMESPACE = "urn:wildfly:microprofile-opentracing-smallrye:3.0";

    public SubsystemExtension() {
        super(EXTENSION_NAME, new String[]{SUBSYSTEM_NAME});
    }

    static ResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        return SubsystemExtension.getResourceDescriptionResolver(false, keyPrefix);
    }

    static ResourceDescriptionResolver getResourceDescriptionResolver(boolean useUnprefixedChildTypes, String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            if (prefix.length() > 0) {
                prefix.append('.');
            }
            prefix.append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, SubsystemExtension.class.getClassLoader(), true, useUnprefixedChildTypes);
    }

    protected Set<ManagementResourceRegistration> initializeLegacyModel(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, CURRENT_MODEL_VERSION);
        subsystem.registerXMLElementWriter((XMLElementWriter)PARSER);
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)new SubsystemDefinition());
        subsystem.registerDeploymentModel((ResourceDefinition)new TracingDeploymentDefinition());
        return Collections.singleton(registration);
    }

    public void initializeLegacyParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, "urn:wildfly:microprofile-opentracing-smallrye:1.0", (XMLElementReader)SubsytemParser_1_0.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, "urn:wildfly:microprofile-opentracing-smallrye:2.0", (XMLElementReader)SubsytemParser_2_0.INSTANCE);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, NAMESPACE, (XMLElementReader)PARSER);
    }

    static {
        CURRENT_MODEL_VERSION = VERSION_3_0_0 = ModelVersion.create((int)3, (int)0, (int)0);
        PARSER = SubsytemParser_3_0.INSTANCE;
    }
}

