/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.instmgr;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.operations.validation.ObjectTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.core.instmgr.InstMgrOperationStepHandler;
import org.wildfly.core.instmgr.InstMgrService;
import org.wildfly.core.instmgr.logging.InstMgrLogger;
import org.wildfly.installationmanager.Channel;
import org.wildfly.installationmanager.Repository;
import org.wildfly.installationmanager.spi.InstallationManager;
import org.wildfly.installationmanager.spi.InstallationManagerFactory;
import org.wildfly.installationmanager.spi.OsShell;

abstract class AbstractInstMgrUpdateHandler
extends InstMgrOperationStepHandler {
    protected static final AttributeDefinition OFFLINE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"offline", (ModelType)ModelType.BOOLEAN).setStorageRuntime()).setDefaultValue(ModelNode.FALSE)).setRequired(false)).build();
    protected static final AttributeDefinition REPOSITORY_ID = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("id", ModelType.STRING).setStorageRuntime()).build();
    protected static final AttributeDefinition REPOSITORY_URL = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("url", ModelType.STRING).setStorageRuntime()).build();
    protected static final ObjectTypeAttributeDefinition REPOSITORY = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)new ObjectTypeAttributeDefinition.Builder("repository", new AttributeDefinition[]{REPOSITORY_ID, REPOSITORY_URL}).setStorageRuntime()).setRequired(false)).setValidator((ParameterValidator)new RepositoryValidator())).setSuffix("repository").build();
    protected static final SimpleAttributeDefinition LOCAL_CACHE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("local-cache", ModelType.STRING).setStorageRuntime()).setRuntimeServiceNotRequired()).addArbitraryDescriptor("filesystem-path", ModelNode.TRUE)).setMinSize(1)).setRequired(false)).setAlternatives(new String[]{"no-resolve-local-cache", "use-default-local-cache"})).build();
    @Deprecated(forRemoval=true)
    protected static final AttributeDefinition NO_RESOLVE_LOCAL_CACHE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"no-resolve-local-cache", (ModelType)ModelType.BOOLEAN).setStorageRuntime()).setRuntimeServiceNotRequired()).setRequired(false)).setStorageRuntime()).setAlternatives(new String[]{"local-cache", "use-default-local-cache"})).setDeprecated(ModelVersion.create((int)24))).build();
    protected static final AttributeDefinition USE_DEFAULT_LOCAL_CACHE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"use-default-local-cache", (ModelType)ModelType.BOOLEAN).setStorageRuntime()).setRuntimeServiceNotRequired()).setRequired(false)).setStorageRuntime()).setAlternatives(new String[]{"local-cache", "no-resolve-local-cache"})).build();

    AbstractInstMgrUpdateHandler(InstMgrService imService, InstallationManagerFactory imf) {
        super(imService, imf);
    }

    protected List<Repository> toRepositories(OperationContext context, List<ModelNode> repositoriesMn) throws OperationFailedException {
        ArrayList<Repository> result = new ArrayList<Repository>();
        if (repositoriesMn != null) {
            for (ModelNode repoModelNode : repositoriesMn) {
                String id = REPOSITORY_ID.resolveModelAttribute(context, repoModelNode).asString();
                String url = REPOSITORY_URL.resolveModelAttribute(context, repoModelNode).asString();
                try {
                    result.add(new Repository(id, new URI(url).toURL().toExternalForm()));
                }
                catch (MalformedURLException | URISyntaxException e) {
                    throw new OperationFailedException((Throwable)e);
                }
            }
        }
        return result;
    }

    protected static OsShell getOsShell() {
        String env = System.getenv("JBOSS_LAUNCH_SCRIPT");
        InstMgrLogger.ROOT_LOGGER.debug("Detected server launched from " + env + " script");
        if (env != null) {
            switch (env) {
                case "powershell": {
                    return OsShell.WindowsPowerShell;
                }
                case "batch": {
                    return OsShell.WindowsBash;
                }
            }
            return OsShell.Linux;
        }
        return OsShell.Linux;
    }

    protected List<Repository> retrieveAllCustomPatchRepositories(InstallationManager im) throws Exception {
        Collection channels = im.listChannels();
        ArrayList<Repository> customChannelRepositories = new ArrayList<Repository>();
        for (Channel c : channels) {
            Path customPatchDir;
            if (!c.getName().startsWith("custom-channel-") || !c.getManifestCoordinate().isPresent()) continue;
            String customPatchManifest = ((String)c.getManifestCoordinate().get()).replace(":", "_");
            String customPatchManifestChannel = c.getName().replace("custom-channel-", "");
            if (!customPatchManifestChannel.equals(customPatchManifest) || !Files.exists(customPatchDir = this.imService.getCustomPatchDir(customPatchManifest), new LinkOption[0])) continue;
            customChannelRepositories.addAll(c.getRepositories());
        }
        return customChannelRepositories;
    }

    private static class RepositoryValidator
    extends ObjectTypeValidator {
        public RepositoryValidator() {
            super(false, new AttributeDefinition[]{REPOSITORY_ID, REPOSITORY_URL});
        }

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            super.validateParameter(parameterName, value);
            String repoUrl = value.get("url").asStringOrNull();
            try {
                new URI(repoUrl).toURL();
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw InstMgrLogger.ROOT_LOGGER.invalidRepositoryURL(repoUrl);
            }
        }
    }
}

