/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.mwlabs.wst.util;

import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.mw.wstx.logging.wstxLogger;
import com.arjuna.webservices.util.ClassLoaderHelper;
import com.arjuna.wst.PersistableParticipant;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class PersistableParticipantHelper {
    public static boolean save_state(OutputObjectState os, Object resource) {
        if (resource != null) {
            try {
                if (resource instanceof Serializable) {
                    os.packBoolean(true);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(baos);
                    oos.writeObject(resource);
                    oos.flush();
                    os.packBytes(baos.toByteArray());
                } else if (resource instanceof PersistableParticipant) {
                    PersistableParticipant participant = (PersistableParticipant)resource;
                    os.packBoolean(false);
                    os.packString(resource.getClass().getName());
                    participant.saveState(os);
                } else {
                    wstxLogger.i18NLogger.error_mwlabs_wst_util_PersistableParticipantHelper_1();
                    return false;
                }
                return true;
            }
            catch (Throwable th) {
                wstxLogger.i18NLogger.error_mwlabs_wst_util_PersistableParticipantHelper_2(th);
                return false;
            }
        }
        return false;
    }

    public static Object restore_state(InputObjectState ios) {
        try {
            boolean serializable = ios.unpackBoolean();
            if (serializable) {
                ByteArrayInputStream bais = new ByteArrayInputStream(ios.unpackBytes());
                ObjectInputStream ois = new ObjectInputStream(bais);
                return ois.readObject();
            }
            String className = ios.unpackString();
            Class resourceClass = ClassLoaderHelper.forName(PersistableParticipantHelper.class, className);
            Object resource = resourceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            ((PersistableParticipant)resource).restoreState(ios);
            return resource;
        }
        catch (Throwable th) {
            wstxLogger.i18NLogger.error_mwlabs_wst_util_PersistableParticipantHelper_3(th);
            return null;
        }
    }
}

