/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.config.impl;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.jboss.modcluster.config.AdvertiseConfiguration;
import org.jboss.modcluster.config.BalancerConfiguration;
import org.jboss.modcluster.config.JvmRouteFactory;
import org.jboss.modcluster.config.MCMPHandlerConfiguration;
import org.jboss.modcluster.config.NodeConfiguration;
import org.jboss.modcluster.config.ProxyConfiguration;
import org.jboss.modcluster.config.SSLConfiguration;
import org.jboss.modcluster.config.SessionDrainingStrategy;
import org.jboss.modcluster.config.impl.SessionDrainingStrategyEnum;
import org.jboss.modcluster.config.impl.SystemPropertyJvmRouteFactory;
import org.jboss.modcluster.config.impl.UUIDJvmRouteFactory;
import org.jboss.modcluster.mcmp.impl.JSSESocketFactory;

public class ModClusterConfig
implements BalancerConfiguration,
MCMPHandlerConfiguration,
NodeConfiguration,
SSLConfiguration,
AdvertiseConfiguration {
    private Boolean advertise;
    private InetSocketAddress advertiseSocketAddress = DEFAULT_SOCKET_ADDRESS;
    private NetworkInterface advertiseInterface = null;
    private String advertiseSecurityKey = null;
    private ThreadFactory advertiseThreadFactory = Executors.defaultThreadFactory();
    private Collection<ProxyConfiguration> proxyConfigurations = Collections.emptySet();
    private String proxyURL = null;
    private int socketTimeout = 20000;
    private boolean ssl = false;
    private Map<String, Set<String>> excludedContextsPerHost = Collections.emptyMap();
    private boolean autoEnableContexts = true;
    private long stopContextTimeout = 10L;
    private TimeUnit stopContextTimeoutUnit = TimeUnit.SECONDS;
    private JvmRouteFactory jvmRouteFactory = new SystemPropertyJvmRouteFactory(new UUIDJvmRouteFactory());
    private SessionDrainingStrategy sessionDrainingStrategy = SessionDrainingStrategyEnum.DEFAULT;
    private String sslCiphers = null;
    private String sslProtocol = "TLS";
    private String sslCertificateEncodingAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
    private String sslKeyStore = System.getProperty("user.home") + "/.keystore";
    private String sslKeyStorePassword = "changeit";
    private String sslKeyStoreType = "JKS";
    private String sslKeyStoreProvider = null;
    private String sslTrustAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
    private String sslKeyAlias = null;
    private String sslCrlFile = null;
    private int sslTrustMaxCertLength = 5;
    private String sslTrustStore = System.getProperty("javax.net.ssl.trustStore");
    private String sslTrustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
    private String sslTrustStoreType = System.getProperty("javax.net.ssl.trustStoreType");
    private String sslTrustStoreProvider = System.getProperty("javax.net.ssl.trustStoreProvider");
    private String loadBalancingGroup = null;
    private boolean flushPackets = false;
    private int flushWait = -1;
    private int ping = -1;
    private int smax = -1;
    private int ttl = -1;
    private int nodeTimeout = -1;
    private String balancer = null;
    private boolean stickySession = true;
    private boolean stickySessionRemove = false;
    private boolean stickySessionForce = false;
    private int workerTimeout = -1;
    private int maxAttempts = -1;

    @Override
    public Boolean getAdvertise() {
        return this.advertise;
    }

    public void setAdvertise(Boolean advertise) {
        this.advertise = advertise;
    }

    @Override
    public InetSocketAddress getAdvertiseSocketAddress() {
        return this.advertiseSocketAddress;
    }

    public void setAdvertiseSocketAddress(InetSocketAddress address) {
        this.advertiseSocketAddress = address;
    }

    @Override
    public NetworkInterface getAdvertiseInterface() {
        return this.advertiseInterface;
    }

    public void setAdvertiseInterface(NetworkInterface advertiseInterface) {
        this.advertiseInterface = advertiseInterface;
    }

    public void setAdvertiseInterface(InetAddress advertiseInterfaceAddress) {
        try {
            this.setAdvertiseInterface(NetworkInterface.getByInetAddress(advertiseInterfaceAddress));
        }
        catch (SocketException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String getAdvertiseSecurityKey() {
        return this.advertiseSecurityKey;
    }

    public void setAdvertiseSecurityKey(String advertiseSecurityKey) {
        this.advertiseSecurityKey = advertiseSecurityKey;
    }

    @Override
    public ThreadFactory getAdvertiseThreadFactory() {
        return this.advertiseThreadFactory;
    }

    public void setAdvertiseThreadFactory(ThreadFactory advertiseThreadFactory) {
        this.advertiseThreadFactory = advertiseThreadFactory;
    }

    @Override
    public Collection<ProxyConfiguration> getProxyConfigurations() {
        return this.proxyConfigurations;
    }

    public void setProxyConfigurations(Collection<ProxyConfiguration> proxyConfigurations) {
        this.proxyConfigurations = proxyConfigurations;
    }

    @Override
    @Deprecated
    public Collection<InetSocketAddress> getProxies() {
        LinkedList<InetSocketAddress> proxies = new LinkedList<InetSocketAddress>();
        for (ProxyConfiguration proxy : this.proxyConfigurations) {
            proxies.add(proxy.getRemoteAddress());
        }
        return proxies;
    }

    @Deprecated
    public void setProxies(Collection<InetSocketAddress> proxies) {
        HashSet<ProxyConfiguration> proxyConfigs = new HashSet<ProxyConfiguration>();
        for (final InetSocketAddress destination : proxies) {
            proxyConfigs.add(new ProxyConfiguration(){

                @Override
                public InetSocketAddress getRemoteAddress() {
                    return destination;
                }

                @Override
                public InetSocketAddress getLocalAddress() {
                    return null;
                }
            });
        }
        this.proxyConfigurations = proxyConfigs;
    }

    @Override
    public String getProxyURL() {
        return this.proxyURL;
    }

    public void setProxyURL(String proxyURL) {
        this.proxyURL = proxyURL;
    }

    @Override
    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    @Override
    @Deprecated
    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    @Override
    public SocketFactory getSocketFactory() {
        if (this.ssl) {
            return new JSSESocketFactory(this);
        }
        return SocketFactory.getDefault();
    }

    @Override
    public Map<String, Set<String>> getExcludedContextsPerHost() {
        return this.excludedContextsPerHost;
    }

    public void setExcludedContextsPerHost(Map<String, Set<String>> excludedContexts) {
        this.excludedContextsPerHost = excludedContexts;
    }

    @Override
    public boolean isAutoEnableContexts() {
        return this.autoEnableContexts;
    }

    public void setAutoEnableContexts(boolean autoEnableContexts) {
        this.autoEnableContexts = autoEnableContexts;
    }

    @Override
    public long getStopContextTimeout() {
        return this.stopContextTimeout;
    }

    public void setStopContextTimeout(int stopContextTimeout) {
        this.stopContextTimeout = stopContextTimeout;
    }

    @Override
    public TimeUnit getStopContextTimeoutUnit() {
        return this.stopContextTimeoutUnit;
    }

    public void setStopContextTimeoutUnit(TimeUnit stopContextTimeoutUnit) {
        this.stopContextTimeoutUnit = stopContextTimeoutUnit;
    }

    @Override
    public JvmRouteFactory getJvmRouteFactory() {
        return this.jvmRouteFactory;
    }

    public void setJvmRouteFactory(JvmRouteFactory jvmRouteFactory) {
        this.jvmRouteFactory = jvmRouteFactory;
    }

    @Override
    public SessionDrainingStrategy getSessionDrainingStrategy() {
        return this.sessionDrainingStrategy;
    }

    public void setSessionDrainingStrategy(SessionDrainingStrategy sessionDrainingStrategy) {
        this.sessionDrainingStrategy = sessionDrainingStrategy;
    }

    @Override
    public String getSslCiphers() {
        return this.sslCiphers;
    }

    public void setSslCiphers(String sslCiphers) {
        this.sslCiphers = sslCiphers;
    }

    @Override
    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    @Override
    public String getSslCertificateEncodingAlgorithm() {
        return this.sslCertificateEncodingAlgorithm;
    }

    public void setSslCertificateEncodingAlgorithm(String sslCertificateEncodingAlgorithm) {
        this.sslCertificateEncodingAlgorithm = sslCertificateEncodingAlgorithm;
    }

    @Override
    public String getSslKeyStore() {
        return this.sslKeyStore;
    }

    public void setSslKeyStore(String sslKeyStore) {
        this.sslKeyStore = sslKeyStore;
    }

    @Override
    public String getSslKeyStorePassword() {
        return this.sslKeyStorePassword;
    }

    public void setSslKeyStorePassword(String sslKeyStorePassword) {
        this.sslKeyStorePassword = sslKeyStorePassword;
    }

    @Override
    public String getSslKeyStoreType() {
        return this.sslKeyStoreType;
    }

    public void setSslKeyStoreType(String sslKeyStoreType) {
        this.sslKeyStoreType = sslKeyStoreType;
    }

    @Override
    public String getSslKeyStoreProvider() {
        return this.sslKeyStoreProvider;
    }

    public void setSslKeyStoreProvider(String sslKeyStoreProvider) {
        this.sslKeyStoreProvider = sslKeyStoreProvider;
    }

    @Override
    public String getSslTrustAlgorithm() {
        return this.sslTrustAlgorithm;
    }

    public void setSslTrustAlgorithm(String sslTrustAlgorithm) {
        this.sslTrustAlgorithm = sslTrustAlgorithm;
    }

    @Override
    public String getSslKeyAlias() {
        return this.sslKeyAlias;
    }

    public void setSslKeyAlias(String sslKeyAlias) {
        this.sslKeyAlias = sslKeyAlias;
    }

    @Override
    public String getSslCrlFile() {
        return this.sslCrlFile;
    }

    public void setSslCrlFile(String sslCrlFile) {
        this.sslCrlFile = sslCrlFile;
    }

    @Override
    public int getSslTrustMaxCertLength() {
        return this.sslTrustMaxCertLength;
    }

    public void setSslTrustMaxCertLength(int sslTrustMaxCertLength) {
        this.sslTrustMaxCertLength = sslTrustMaxCertLength;
    }

    @Override
    public String getSslTrustStore() {
        return this.sslTrustStore;
    }

    public void setSslTrustStore(String sslTrustStore) {
        this.sslTrustStore = sslTrustStore;
    }

    @Override
    public String getSslTrustStorePassword() {
        return this.sslTrustStorePassword;
    }

    public void setSslTrustStorePassword(String sslTrustStorePassword) {
        this.sslTrustStorePassword = sslTrustStorePassword;
    }

    @Override
    public String getSslTrustStoreType() {
        return this.sslTrustStoreType;
    }

    public void setSslTrustStoreType(String sslTrustStoreType) {
        this.sslTrustStoreType = sslTrustStoreType;
    }

    @Override
    public String getSslTrustStoreProvider() {
        return this.sslTrustStoreProvider;
    }

    public void setSslTrustStoreProvider(String sslTrustStoreProvider) {
        this.sslTrustStoreProvider = sslTrustStoreProvider;
    }

    @Override
    public String getLoadBalancingGroup() {
        return this.loadBalancingGroup;
    }

    public void setLoadBalancingGroup(String loadBalancingGroup) {
        this.loadBalancingGroup = loadBalancingGroup;
    }

    @Override
    public boolean getFlushPackets() {
        return this.flushPackets;
    }

    public void setFlushPackets(boolean flushPackets) {
        this.flushPackets = flushPackets;
    }

    @Override
    public int getFlushWait() {
        return this.flushWait;
    }

    public void setFlushWait(int flushWait) {
        this.flushWait = flushWait;
    }

    @Override
    public int getPing() {
        return this.ping;
    }

    public void setPing(int ping) {
        this.ping = ping;
    }

    @Override
    public int getSmax() {
        return this.smax;
    }

    public void setSmax(int smax) {
        this.smax = smax;
    }

    @Override
    public int getTtl() {
        return this.ttl;
    }

    public void setTtl(int ttl) {
        this.ttl = ttl;
    }

    @Override
    public int getNodeTimeout() {
        return this.nodeTimeout;
    }

    public void setNodeTimeout(int nodeTimeout) {
        this.nodeTimeout = nodeTimeout;
    }

    @Override
    public String getBalancer() {
        return this.balancer;
    }

    public void setBalancer(String balancer) {
        this.balancer = balancer;
    }

    @Override
    public boolean getStickySession() {
        return this.stickySession;
    }

    public void setStickySession(boolean stickySession) {
        this.stickySession = stickySession;
    }

    @Override
    public boolean getStickySessionRemove() {
        return this.stickySessionRemove;
    }

    public void setStickySessionRemove(boolean stickySessionRemove) {
        this.stickySessionRemove = stickySessionRemove;
    }

    @Override
    public boolean getStickySessionForce() {
        return this.stickySessionForce;
    }

    public void setStickySessionForce(boolean stickySessionForce) {
        this.stickySessionForce = stickySessionForce;
    }

    @Override
    public int getWorkerTimeout() {
        return this.workerTimeout;
    }

    public void setWorkerTimeout(int workerTimeout) {
        this.workerTimeout = workerTimeout;
    }

    @Override
    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }
}

