/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.Set;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemModel;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolChildResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinitionRegistrar;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.global.MapOperations;
import org.jboss.dmr.ModelNode;
import org.jgroups.protocols.FD_ALL2;
import org.wildfly.subsystem.resource.ResourceDescriptor;

public class LegacyProtocolResourceDefinitionRegistrar
extends ProtocolChildResourceDefinitionRegistrar {
    private final PathElement targetPath;

    LegacyProtocolResourceDefinitionRegistrar(final Protocol protocol) {
        super(new ProtocolChildResourceDefinitionRegistrar.Configurator(){

            @Override
            public ResourceRegistration getResourceRegistration() {
                return protocol;
            }

            @Override
            public ResourceDescriptionResolver getResourceDescriptionResolver() {
                return JGroupsSubsystemResourceDefinitionRegistrar.RESOLVER.createChildResolver(protocol.getPathElement(), StackResourceDefinitionRegistrar.Component.PROTOCOL.getPathElement());
            }

            @Override
            public JGroupsSubsystemModel getDeprecation() {
                return protocol.getDeprecation();
            }
        });
        this.targetPath = protocol.getTargetPathElement();
    }

    @Override
    public ResourceDescriptor.Builder apply(ResourceDescriptor.Builder builder) {
        return (ResourceDescriptor.Builder)super.apply(builder).withOperationTransformation(Set.of("add", "remove", MapOperations.MAP_GET_DEFINITION.getName(), MapOperations.MAP_PUT_DEFINITION.getName(), MapOperations.MAP_REMOVE_DEFINITION.getName(), MapOperations.MAP_CLEAR_DEFINITION.getName()), (UnaryOperator)new UnaryOperator<OperationStepHandler>(){

            @Override
            public OperationStepHandler apply(OperationStepHandler handler) {
                return new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) {
                        PathAddress address = context.getCurrentAddress();
                        JGroupsLogger.ROOT_LOGGER.legacyProtocol(address.getLastElement().getValue(), LegacyProtocolResourceDefinitionRegistrar.this.targetPath.getValue());
                        PathAddress targetAddress = address.getParent().append(new PathElement[]{LegacyProtocolResourceDefinitionRegistrar.this.targetPath});
                        operation.get("address").set(targetAddress.toModelNode());
                        PathAddress targetRegistrationAddress = address.getParent().append(new PathElement[]{StackResourceDefinitionRegistrar.Component.PROTOCOL.getPathElement()});
                        String operationName = operation.get("operation").asString();
                        context.addStep(operation, context.getRootResourceRegistration().getOperationHandler(targetRegistrationAddress, operationName), OperationContext.Stage.MODEL, true);
                    }
                };
            }
        });
    }

    static enum Protocol implements ResourceRegistration
    {
        FD(FD_ALL2.class, JGroupsSubsystemModel.VERSION_10_0_0);

        private final PathElement path;
        private final PathElement targetPath;
        private final JGroupsSubsystemModel deprecation;

        private Protocol(Class<? extends org.jgroups.stack.Protocol> targetProtocol, JGroupsSubsystemModel deprecation) {
            this(null, targetProtocol, deprecation);
        }

        private Protocol(String name, Class<? extends org.jgroups.stack.Protocol> targetProtocol, JGroupsSubsystemModel deprecation) {
            this.path = StackResourceDefinitionRegistrar.Component.PROTOCOL.pathElement(name != null ? name : this.name());
            this.targetPath = StackResourceDefinitionRegistrar.Component.PROTOCOL.pathElement(targetProtocol.getName().substring("org.jgroups.protocols.".length()));
            this.deprecation = deprecation;
        }

        public PathElement getPathElement() {
            return this.path;
        }

        PathElement getTargetPathElement() {
            return this.targetPath;
        }

        JGroupsSubsystemModel getDeprecation() {
            return this.deprecation;
        }
    }
}

