/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolConfigurationResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinitionRegistrar;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jgroups.protocols.MPING;
import org.wildfly.clustering.jgroups.spi.ChannelFactoryConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.service.Dependency;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.capability.CapabilityReference;
import org.wildfly.subsystem.resource.capability.CapabilityReferenceAttributeDefinition;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ServiceDependency;

public class MulticastProtocolResourceDefinitionRegistrar
extends AbstractProtocolResourceDefinitionRegistrar<MPING> {
    static final CapabilityReferenceAttributeDefinition<SocketBinding> SOCKET_BINDING = ((CapabilityReferenceAttributeDefinition.Builder)((CapabilityReferenceAttributeDefinition.Builder)new CapabilityReferenceAttributeDefinition.Builder("socket-binding", CapabilityReference.builder((RuntimeCapability)CAPABILITY, (UnaryServiceDescriptor)SocketBinding.SERVICE_DESCRIPTOR).build()).setRequired(true)).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF})).build();

    MulticastProtocolResourceDefinitionRegistrar(final Protocol registration, final ResourceOperationRuntimeHandler parentRuntimeHandler) {
        super(new AbstractProtocolResourceDefinitionRegistrar.Configurator(){

            @Override
            public ResourceRegistration getResourceRegistration() {
                return registration;
            }

            @Override
            public ResourceOperationRuntimeHandler getParentRuntimeHandler() {
                return parentRuntimeHandler;
            }
        });
    }

    @Override
    public ResourceDescriptor.Builder apply(ResourceDescriptor.Builder builder) {
        return (ResourceDescriptor.Builder)super.apply(builder).addAttributes(List.of(SOCKET_BINDING));
    }

    @Override
    public ServiceDependency<ProtocolConfiguration<MPING>> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        return super.resolve(context, model).combine((Dependency)SOCKET_BINDING.resolve(context, model), (BiFunction)new BiFunction<ProtocolConfiguration<MPING>, SocketBinding, ProtocolConfiguration<MPING>>(){

            @Override
            public ProtocolConfiguration<MPING> apply(ProtocolConfiguration<MPING> config, final SocketBinding binding) {
                return new ProtocolConfigurationResourceDefinitionRegistrar.ProtocolConfigurationDecorator<MPING>(config){

                    @Override
                    public MPING createProtocol(ChannelFactoryConfiguration stackConfiguration) {
                        MPING protocol = (MPING)super.createProtocol(stackConfiguration);
                        protocol.setBindAddr(binding.getAddress());
                        protocol.setMcastAddr(binding.getMulticastAddress());
                        protocol.setMcastPort(binding.getMulticastPort());
                        return protocol;
                    }

                    @Override
                    public Map<String, SocketBinding> getSocketBindings() {
                        return Map.of("jgroups.mping.mcast_sock", binding, "jgroups.mping.mcast-send-sock", binding);
                    }
                };
            }
        });
    }

    static enum Protocol implements ResourceRegistration
    {
        MPING;

        private final PathElement path = StackResourceDefinitionRegistrar.Component.PROTOCOL.pathElement(this.name());

        public PathElement getPathElement() {
            return this.path;
        }
    }
}

