/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.externalizers;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.query.impl.externalizers.ExternalizerIds;

public class PojoRawTypeIdentifierExternalizer
extends AbstractExternalizer<PojoRawTypeIdentifier> {
    public Integer getId() {
        return ExternalizerIds.POJO_TYPE_IDENTIFIER;
    }

    public Set<Class<? extends PojoRawTypeIdentifier>> getTypeClasses() {
        return Collections.singleton(PojoRawTypeIdentifier.class);
    }

    public void writeObject(ObjectOutput output, PojoRawTypeIdentifier object) throws IOException {
        output.writeObject(object.javaClass());
        if (object.isNamed()) {
            String name = (String)ReflectionUtil.getValue((Object)object, (String)"name");
            output.writeObject(Optional.of(name));
        } else {
            output.writeObject(Optional.empty());
        }
    }

    public PojoRawTypeIdentifier readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        Class javaClass = (Class)input.readObject();
        Optional typeName = (Optional)input.readObject();
        return typeName.isPresent() ? PojoRawTypeIdentifier.of((Class)javaClass, (String)((String)typeName.get())) : PojoRawTypeIdentifier.of((Class)javaClass);
    }
}

