/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.tx.noopts;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.transaction.xa.XAResource;

public class TransactionImpl
implements Transaction,
Serializable {
    private static final long serialVersionUID = 3L;
    private transient Long key;
    private transient int status;
    private transient Set<Synchronization> syncs;
    private transient Map<Object, Object> resources;

    public TransactionImpl(Long key) {
        this.key = key;
        this.status = 0;
        this.syncs = new HashSet<Synchronization>();
        this.resources = new HashMap<Object, Object>();
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (this.status == 5) {
            throw new IllegalStateException("Status unknown");
        }
        if (this.status == 1) {
            throw new IllegalStateException("Status marked rollback");
        }
        this.finish(true);
    }

    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        if (this.status == 5) {
            throw new IllegalStateException("Status unknown");
        }
        if (this.status != 0 && this.status != 1) {
            throw new IllegalStateException("Status not valid");
        }
        return true;
    }

    public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
        if (this.status == 5) {
            throw new IllegalStateException("Status unknown");
        }
        return true;
    }

    public int getStatus() throws SystemException {
        return this.status;
    }

    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        if (this.status == 5) {
            throw new IllegalStateException("Status unknown");
        }
        this.syncs.add(sync);
    }

    public void rollback() throws IllegalStateException, SystemException {
        if (this.status == 5) {
            throw new IllegalStateException("Status unknown");
        }
        this.finish(false);
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        if (this.status == 5) {
            throw new IllegalStateException("Status unknown");
        }
        this.status = 1;
    }

    boolean getRollbackOnly() {
        if (this.status == 5) {
            throw new IllegalStateException("Status unknown");
        }
        return this.status == 1;
    }

    void putResource(Object key, Object value) {
        this.resources.put(key, value);
    }

    Object getResource(Object key) {
        return this.resources.get(key);
    }

    Long getKey() {
        return this.key;
    }

    void active() {
        this.status = 0;
    }

    private void finish(boolean commit) {
        for (Synchronization s : this.syncs) {
            s.beforeCompletion();
        }
        this.status = commit ? 3 : 4;
        for (Synchronization s : this.syncs) {
            s.afterCompletion(this.status);
        }
        this.status = 5;
        this.syncs.clear();
        this.resources.clear();
    }
}

