/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.embedded;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.jboss.as.cli.embedded.Contexts;
import org.jboss.as.cli.embedded.ThreadLocalContextSelector;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.dmr.ModelNode;

class ThreadContextsModelControllerClient
implements ModelControllerClient {
    private final ModelControllerClient delegate;
    private final ThreadLocalContextSelector contextSelector;

    ThreadContextsModelControllerClient(ModelControllerClient delegate, ThreadLocalContextSelector contextSelector) {
        assert (delegate != null);
        assert (contextSelector != null);
        this.delegate = delegate;
        this.contextSelector = contextSelector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelNode execute(ModelNode operation) throws IOException {
        Contexts existing = this.contextSelector.pushLocal();
        try {
            ModelNode modelNode = this.delegate.execute(operation);
            return modelNode;
        }
        finally {
            this.contextSelector.restore(existing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelNode execute(Operation operation) throws IOException {
        Contexts existing = this.contextSelector.pushLocal();
        try {
            ModelNode modelNode = this.delegate.execute(operation);
            return modelNode;
        }
        finally {
            this.contextSelector.restore(existing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelNode execute(ModelNode operation, OperationMessageHandler messageHandler) throws IOException {
        Contexts existing = this.contextSelector.pushLocal();
        try {
            ModelNode modelNode = this.delegate.execute(operation, messageHandler);
            return modelNode;
        }
        finally {
            this.contextSelector.restore(existing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelNode execute(Operation operation, OperationMessageHandler messageHandler) throws IOException {
        Contexts existing = this.contextSelector.pushLocal();
        try {
            ModelNode modelNode = this.delegate.execute(operation, messageHandler);
            return modelNode;
        }
        finally {
            this.contextSelector.restore(existing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse executeOperation(Operation operation, OperationMessageHandler messageHandler) throws IOException {
        Contexts existing = this.contextSelector.pushLocal();
        try {
            OperationResponse operationResponse = this.delegate.executeOperation(operation, messageHandler);
            return operationResponse;
        }
        finally {
            this.contextSelector.restore(existing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<ModelNode> executeAsync(ModelNode operation, OperationMessageHandler messageHandler) {
        Contexts existing = this.contextSelector.pushLocal();
        try {
            CompletableFuture<ModelNode> completableFuture = this.delegate.executeAsync(operation, messageHandler);
            return completableFuture;
        }
        finally {
            this.contextSelector.restore(existing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<ModelNode> executeAsync(Operation operation, OperationMessageHandler messageHandler) {
        Contexts existing = this.contextSelector.pushLocal();
        try {
            CompletableFuture<ModelNode> completableFuture = this.delegate.executeAsync(operation, messageHandler);
            return completableFuture;
        }
        finally {
            this.contextSelector.restore(existing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<OperationResponse> executeOperationAsync(Operation operation, OperationMessageHandler messageHandler) {
        Contexts existing = this.contextSelector.pushLocal();
        try {
            CompletableFuture<OperationResponse> completableFuture = this.delegate.executeOperationAsync(operation, messageHandler);
            return completableFuture;
        }
        finally {
            this.contextSelector.restore(existing);
        }
    }

    @Override
    public void close() throws IOException {
        Contexts existing = this.contextSelector.pushLocal();
        try {
            this.delegate.close();
        }
        finally {
            this.contextSelector.restore(existing);
        }
    }
}

