/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl.toJavaPortable;

import com.sun.tools.corba.se.idl.EnumEntry;
import com.sun.tools.corba.se.idl.GenFileStream;
import com.sun.tools.corba.se.idl.PrimitiveEntry;
import com.sun.tools.corba.se.idl.SequenceEntry;
import com.sun.tools.corba.se.idl.StringEntry;
import com.sun.tools.corba.se.idl.SymtabEntry;
import com.sun.tools.corba.se.idl.TypedefEntry;
import com.sun.tools.corba.se.idl.UnionBranch;
import com.sun.tools.corba.se.idl.UnionEntry;
import com.sun.tools.corba.se.idl.constExpr.EvaluationException;
import com.sun.tools.corba.se.idl.constExpr.Expression;
import com.sun.tools.corba.se.idl.toJavaPortable.Compile;
import com.sun.tools.corba.se.idl.toJavaPortable.Factories;
import com.sun.tools.corba.se.idl.toJavaPortable.JavaGenerator;
import com.sun.tools.corba.se.idl.toJavaPortable.TCOffsets;
import com.sun.tools.corba.se.idl.toJavaPortable.Util;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class UnionGen
implements com.sun.tools.corba.se.idl.UnionGen,
JavaGenerator {
    protected Hashtable symbolTable = null;
    protected UnionEntry u = null;
    protected PrintWriter stream = null;
    protected SymtabEntry utype = null;
    protected boolean unionIsEnum;
    protected String typePackage = "";

    @Override
    public void generate(Hashtable symbolTable, UnionEntry u, PrintWriter s) {
        this.symbolTable = symbolTable;
        this.u = u;
        this.init();
        this.openStream();
        if (this.stream == null) {
            return;
        }
        this.generateHelper();
        this.generateHolder();
        this.writeHeading();
        this.writeBody();
        this.writeClosing();
        this.closeStream();
        this.generateContainedTypes();
    }

    protected void init() {
        this.utype = Util.typeOf(this.u.type());
        this.unionIsEnum = this.utype instanceof EnumEntry;
    }

    protected void openStream() {
        this.stream = Util.stream(this.u, ".java");
    }

    protected void generateHelper() {
        ((Factories)Compile.compiler.factories()).helper().generate(this.symbolTable, this.u);
    }

    protected void generateHolder() {
        ((Factories)Compile.compiler.factories()).holder().generate(this.symbolTable, this.u);
    }

    protected void writeHeading() {
        this.typePackage = this.unionIsEnum ? Util.javaQualifiedName(this.utype) + "." : "";
        Util.writePackage(this.stream, this.u);
        Util.writeProlog(this.stream, ((GenFileStream)this.stream).name());
        String className = this.u.name();
        this.stream.println("public final class " + this.u.name() + " implements org.omg.CORBA.portable.IDLEntity");
        this.stream.println("{");
    }

    protected void writeBody() {
        UnionBranch branch;
        int size = this.u.branches().size() + 1;
        Enumeration e = this.u.branches().elements();
        int i = 0;
        while (e.hasMoreElements()) {
            branch = (UnionBranch)e.nextElement();
            Util.fillInfo(branch.typedef);
            this.stream.println("  private " + Util.javaName(branch.typedef) + " ___" + branch.typedef.name() + ";");
            ++i;
        }
        this.stream.println("  private " + Util.javaName(this.utype) + " __discriminator;");
        this.stream.println("  private boolean __uninitialized = true;");
        this.stream.println();
        this.stream.println("  public " + this.u.name() + " ()");
        this.stream.println("  {");
        this.stream.println("  }");
        this.stream.println();
        this.stream.println("  public " + Util.javaName(this.utype) + " " + this.safeName(this.u, "discriminator") + " ()");
        this.stream.println("  {");
        this.stream.println("    if (__uninitialized)");
        this.stream.println("      throw new org.omg.CORBA.BAD_OPERATION ();");
        this.stream.println("    return __discriminator;");
        this.stream.println("  }");
        e = this.u.branches().elements();
        i = 0;
        while (e.hasMoreElements()) {
            branch = (UnionBranch)e.nextElement();
            this.writeBranchMethods(this.stream, this.u, branch, i++);
        }
        if (this.u.defaultBranch() == null && !this.coversAll(this.u)) {
            this.stream.println();
            this.stream.println("  public void _default ()");
            this.stream.println("  {");
            this.stream.println("    __discriminator = " + this.defaultDiscriminator(this.u) + ";");
            this.stream.println("    __uninitialized = false;");
            this.stream.println("  }");
            this.stream.println();
            this.stream.println("  public void _default (" + Util.javaName(this.utype) + " discriminator)");
            this.stream.println("  {");
            this.stream.println("    verifyDefault( discriminator ) ;");
            this.stream.println("    __discriminator = discriminator ;");
            this.stream.println("    __uninitialized = false;");
            this.stream.println("  }");
            this.writeVerifyDefault();
        }
        this.stream.println();
    }

    protected void writeClosing() {
        this.stream.println("} // class " + this.u.name());
    }

    protected void closeStream() {
        this.stream.close();
    }

    protected void generateContainedTypes() {
        Enumeration e = this.u.contained().elements();
        while (e.hasMoreElements()) {
            SymtabEntry entry = (SymtabEntry)e.nextElement();
            if (entry instanceof SequenceEntry) continue;
            entry.generate(this.symbolTable, this.stream);
        }
    }

    private void writeVerifyDefault() {
        Vector labels = this.vectorizeLabels(this.u.branches(), true);
        if (Util.javaName(this.utype).equals("boolean")) {
            this.stream.println("");
            this.stream.println("  private void verifyDefault (boolean discriminator)");
            this.stream.println("  {");
            if (labels.contains("true")) {
                this.stream.println("    if ( discriminator )");
            } else {
                this.stream.println("    if ( !discriminator )");
            }
            this.stream.println("        throw new org.omg.CORBA.BAD_OPERATION();");
            this.stream.println("  }");
            return;
        }
        this.stream.println("");
        this.stream.println("  private void verifyDefault( " + Util.javaName(this.utype) + " value )");
        this.stream.println("  {");
        if (this.unionIsEnum) {
            this.stream.println("    switch (value.value()) {");
        } else {
            this.stream.println("    switch (value) {");
        }
        Enumeration e = labels.elements();
        while (e.hasMoreElements()) {
            String str = (String)e.nextElement();
            this.stream.println("      case " + str + ":");
        }
        this.stream.println("        throw new org.omg.CORBA.BAD_OPERATION() ;");
        this.stream.println("");
        this.stream.println("      default:");
        this.stream.println("        return;");
        this.stream.println("    }");
        this.stream.println("  }");
    }

    private String defaultDiscriminator(UnionEntry u) {
        Vector labels = this.vectorizeLabels(u.branches(), false);
        Object ret = null;
        SymtabEntry utype = Util.typeOf(u.type());
        if (utype instanceof PrimitiveEntry && utype.name().equals("boolean")) {
            ret = labels.contains("true") ? "false" : "true";
        } else if (utype.name().equals("char")) {
            int def = 0;
            Object string = "'\\u0000'";
            while (def != 65535 && labels.contains(string)) {
                if (++def / 16 == 0) {
                    string = "'\\u000" + def + "'";
                    continue;
                }
                if (def / 256 == 0) {
                    string = "\\u00" + def + "'";
                    continue;
                }
                if (def / 4096 == 0) {
                    string = "\\u0" + def + "'";
                    continue;
                }
                string = "\\u" + def + "'";
            }
            ret = string;
        } else if (utype instanceof EnumEntry) {
            Enumeration e = labels.elements();
            EnumEntry enumEntry = (EnumEntry)utype;
            Vector enumList = (Vector)enumEntry.elements().clone();
            while (e.hasMoreElements()) {
                enumList.removeElement(e.nextElement());
            }
            ret = enumList.size() == 0 ? this.typePackage + (String)enumEntry.elements().lastElement() : this.typePackage + (String)enumList.firstElement();
        } else if (utype.name().equals("octet")) {
            int def;
            for (def = -128; def != 127 && labels.contains(Integer.toString(def)); def = (int)((short)(def + 1))) {
            }
            ret = Integer.toString(def);
        } else if (utype.name().equals("short")) {
            int def;
            for (def = Short.MIN_VALUE; def != Short.MAX_VALUE && labels.contains(Integer.toString(def)); def = (int)((short)(def + 1))) {
            }
            ret = Integer.toString(def);
        } else if (utype.name().equals("long")) {
            int def;
            for (def = Integer.MIN_VALUE; def != Integer.MAX_VALUE && labels.contains(Integer.toString(def)); ++def) {
            }
            ret = Integer.toString(def);
        } else if (utype.name().equals("long long")) {
            long def;
            for (def = Long.MIN_VALUE; def != Long.MAX_VALUE && labels.contains(Long.toString(def)); ++def) {
            }
            ret = Long.toString(def);
        } else if (utype.name().equals("unsigned short")) {
            int def;
            for (def = 0; def != Short.MAX_VALUE && labels.contains(Integer.toString(def)); def = (int)((short)(def + 1))) {
            }
            ret = Integer.toString(def);
        } else if (utype.name().equals("unsigned long")) {
            int def;
            for (def = 0; def != Integer.MAX_VALUE && labels.contains(Integer.toString(def)); ++def) {
            }
            ret = Integer.toString(def);
        } else if (utype.name().equals("unsigned long long")) {
            long def;
            for (def = 0L; def != Long.MAX_VALUE && labels.contains(Long.toString(def)); ++def) {
            }
            ret = Long.toString(def);
        }
        return ret;
    }

    private Vector vectorizeLabels(Vector branchVector, boolean useIntsForEnums) {
        Vector<String> mergedLabels = new Vector<String>();
        Enumeration branches = branchVector.elements();
        while (branches.hasMoreElements()) {
            UnionBranch branch = (UnionBranch)branches.nextElement();
            Enumeration labels = branch.labels.elements();
            while (labels.hasMoreElements()) {
                Expression expr = (Expression)labels.nextElement();
                Object str = this.unionIsEnum ? (useIntsForEnums ? this.typePackage + "_" + Util.parseExpression(expr) : this.typePackage + Util.parseExpression(expr)) : Util.parseExpression(expr);
                mergedLabels.addElement((String)str);
            }
        }
        return mergedLabels;
    }

    private String safeName(UnionEntry u, String name) {
        Enumeration e = u.branches().elements();
        while (e.hasMoreElements()) {
            if (!((UnionBranch)e.nextElement()).typedef.name().equals(name)) continue;
            name = "_" + (String)name;
            break;
        }
        return name;
    }

    private boolean coversAll(UnionEntry u) {
        Vector labels;
        SymtabEntry utype = Util.typeOf(u.type());
        boolean coversAll = false;
        if (utype.name().equals("boolean")) {
            if (u.branches().size() == 2) {
                coversAll = true;
            }
        } else if (utype instanceof EnumEntry && (labels = this.vectorizeLabels(u.branches(), true)).size() == ((EnumEntry)utype).elements().size()) {
            coversAll = true;
        }
        return coversAll;
    }

    private void writeBranchMethods(PrintWriter stream, UnionEntry u, UnionBranch branch, int i) {
        stream.println();
        stream.println("  public " + Util.javaName(branch.typedef) + " " + branch.typedef.name() + " ()");
        stream.println("  {");
        stream.println("    if (__uninitialized)");
        stream.println("      throw new org.omg.CORBA.BAD_OPERATION ();");
        stream.println("    verify" + branch.typedef.name() + " (__discriminator);");
        stream.println("    return ___" + branch.typedef.name() + ";");
        stream.println("  }");
        stream.println();
        stream.println("  public void " + branch.typedef.name() + " (" + Util.javaName(branch.typedef) + " value)");
        stream.println("  {");
        if (branch.labels.size() == 0) {
            stream.println("    __discriminator = " + this.defaultDiscriminator(u) + ";");
        } else if (this.unionIsEnum) {
            stream.println("    __discriminator = " + this.typePackage + Util.parseExpression((Expression)branch.labels.firstElement()) + ";");
        } else {
            stream.println("    __discriminator = " + this.cast((Expression)branch.labels.firstElement(), u.type()) + ";");
        }
        stream.println("    ___" + branch.typedef.name() + " = value;");
        stream.println("    __uninitialized = false;");
        stream.println("  }");
        SymtabEntry utype = Util.typeOf(u.type());
        if (branch.labels.size() > 0 || branch.isDefault) {
            stream.println();
            stream.println("  public void " + branch.typedef.name() + " (" + Util.javaName(utype) + " discriminator, " + Util.javaName(branch.typedef) + " value)");
            stream.println("  {");
            stream.println("    verify" + branch.typedef.name() + " (discriminator);");
            stream.println("    __discriminator = discriminator;");
            stream.println("    ___" + branch.typedef.name() + " = value;");
            stream.println("    __uninitialized = false;");
            stream.println("  }");
        }
        stream.println();
        stream.println("  private void verify" + branch.typedef.name() + " (" + Util.javaName(utype) + " discriminator)");
        stream.println("  {");
        boolean onlyOne = true;
        if (!branch.isDefault || u.branches().size() != 1) {
            stream.print("    if (");
            if (branch.isDefault) {
                Enumeration eBranches = u.branches().elements();
                while (eBranches.hasMoreElements()) {
                    UnionBranch b = (UnionBranch)eBranches.nextElement();
                    if (b == branch) continue;
                    Enumeration eLabels = b.labels.elements();
                    while (eLabels.hasMoreElements()) {
                        Expression label = (Expression)eLabels.nextElement();
                        if (!onlyOne) {
                            stream.print(" || ");
                        }
                        if (this.unionIsEnum) {
                            stream.print("discriminator == " + this.typePackage + Util.parseExpression(label));
                        } else {
                            stream.print("discriminator == " + Util.parseExpression(label));
                        }
                        onlyOne = false;
                    }
                }
            } else {
                Enumeration e = branch.labels.elements();
                while (e.hasMoreElements()) {
                    Expression label = (Expression)e.nextElement();
                    if (!onlyOne) {
                        stream.print(" && ");
                    }
                    if (this.unionIsEnum) {
                        stream.print("discriminator != " + this.typePackage + Util.parseExpression(label));
                    } else {
                        stream.print("discriminator != " + Util.parseExpression(label));
                    }
                    onlyOne = false;
                }
            }
            stream.println(")");
            stream.println("      throw new org.omg.CORBA.BAD_OPERATION ();");
        }
        stream.println("  }");
    }

    private int unionLabelSize(UnionEntry un) {
        int size = 0;
        Vector branches = un.branches();
        for (int i = 0; i < branches.size(); ++i) {
            UnionBranch branch = (UnionBranch)branches.get(i);
            int branchSize = branch.labels.size();
            size += branchSize == 0 ? 1 : branchSize;
        }
        return size;
    }

    @Override
    public int helperType(int index, String indent, TCOffsets tcoffsets, String name, SymtabEntry entry, PrintWriter stream) {
        TCOffsets innerOffsets = new TCOffsets();
        UnionEntry u = (UnionEntry)entry;
        String discTypeCode = "_disTypeCode" + index;
        String membersName = "_members" + index;
        stream.println(indent + "org.omg.CORBA.TypeCode " + discTypeCode + ";");
        index = ((JavaGenerator)((Object)u.type().generator())).type(index + 1, indent, innerOffsets, discTypeCode, u.type(), stream);
        tcoffsets.bumpCurrentOffset(innerOffsets.currentOffset());
        stream.println(indent + "org.omg.CORBA.UnionMember[] " + membersName + " = new org.omg.CORBA.UnionMember [" + this.unionLabelSize(u) + "];");
        String tcOfMembers = "_tcOf" + membersName;
        String anyOfMembers = "_anyOf" + membersName;
        stream.println(indent + "org.omg.CORBA.TypeCode " + tcOfMembers + ";");
        stream.println(indent + "org.omg.CORBA.Any " + anyOfMembers + ";");
        innerOffsets = new TCOffsets();
        innerOffsets.set(entry);
        int offsetForUnion = innerOffsets.currentOffset();
        for (int i = 0; i < u.branches().size(); ++i) {
            UnionBranch branch = (UnionBranch)u.branches().elementAt(i);
            TypedefEntry member = branch.typedef;
            Vector labels = branch.labels;
            String memberName = Util.stripLeadingUnderscores(member.name());
            if (labels.size() == 0) {
                stream.println();
                stream.println(indent + "// Branch for " + memberName + " (Default case)");
                SymtabEntry utype = Util.typeOf(u.type());
                stream.println(indent + anyOfMembers + " = org.omg.CORBA.ORB.init ().create_any ();");
                stream.println(indent + anyOfMembers + ".insert_octet ((byte)0); // default member label");
                innerOffsets.bumpCurrentOffset(4);
                index = ((JavaGenerator)((Object)member.generator())).type(index, indent, innerOffsets, tcOfMembers, member, stream);
                int offsetSoFar = innerOffsets.currentOffset();
                innerOffsets = new TCOffsets();
                innerOffsets.set(entry);
                innerOffsets.bumpCurrentOffset(offsetSoFar - offsetForUnion);
                stream.println(indent + membersName + "[" + i + "] = new org.omg.CORBA.UnionMember (");
                stream.println(indent + "  \"" + memberName + "\",");
                stream.println(indent + "  " + anyOfMembers + ",");
                stream.println(indent + "  " + tcOfMembers + ",");
                stream.println(indent + "  null);");
                continue;
            }
            Enumeration enumeration = labels.elements();
            while (enumeration.hasMoreElements()) {
                Expression expr = (Expression)enumeration.nextElement();
                String elem = Util.parseExpression(expr);
                stream.println();
                stream.println(indent + "// Branch for " + memberName + " (case label " + elem + ")");
                SymtabEntry utype = Util.typeOf(u.type());
                stream.println(indent + anyOfMembers + " = org.omg.CORBA.ORB.init ().create_any ();");
                if (utype instanceof PrimitiveEntry) {
                    stream.println(indent + anyOfMembers + ".insert_" + Util.collapseName(utype.name()) + " ((" + Util.javaName(utype) + ")" + elem + ");");
                } else {
                    String enumClass = Util.javaName(utype);
                    stream.println(indent + Util.helperName(utype, false) + ".insert (" + anyOfMembers + ", " + enumClass + "." + elem + ");");
                }
                innerOffsets.bumpCurrentOffset(4);
                index = ((JavaGenerator)((Object)member.generator())).type(index, indent, innerOffsets, tcOfMembers, member, stream);
                int offsetSoFar = innerOffsets.currentOffset();
                innerOffsets = new TCOffsets();
                innerOffsets.set(entry);
                innerOffsets.bumpCurrentOffset(offsetSoFar - offsetForUnion);
                stream.println(indent + membersName + "[" + i + "] = new org.omg.CORBA.UnionMember (");
                stream.println(indent + "  \"" + memberName + "\",");
                stream.println(indent + "  " + anyOfMembers + ",");
                stream.println(indent + "  " + tcOfMembers + ",");
                stream.println(indent + "  null);");
            }
        }
        tcoffsets.bumpCurrentOffset(innerOffsets.currentOffset());
        stream.println(indent + name + " = org.omg.CORBA.ORB.init ().create_union_tc (" + Util.helperName(u, true) + ".id (), \"" + entry.name() + "\", " + discTypeCode + ", " + membersName + ");");
        return index;
    }

    @Override
    public int type(int index, String indent, TCOffsets tcoffsets, String name, SymtabEntry entry, PrintWriter stream) {
        stream.println(indent + name + " = " + Util.helperName(entry, true) + ".type ();");
        return index;
    }

    @Override
    public void helperRead(String entryName, SymtabEntry entry, PrintWriter stream) {
        stream.println("    " + entryName + " value = new " + entryName + " ();");
        this.read(0, "    ", "value", entry, stream);
        stream.println("    return value;");
    }

    @Override
    public void helperWrite(SymtabEntry entry, PrintWriter stream) {
        this.write(0, "    ", "value", entry, stream);
    }

    @Override
    public int read(int index, String indent, String name, SymtabEntry entry, PrintWriter stream) {
        UnionEntry u = (UnionEntry)entry;
        String disName = "_dis" + index++;
        SymtabEntry utype = Util.typeOf(u.type());
        Util.writeInitializer(indent, disName, "", utype, stream);
        if (utype instanceof PrimitiveEntry) {
            index = ((JavaGenerator)((Object)utype.generator())).read(index, indent, disName, utype, stream);
        } else {
            stream.println(indent + disName + " = " + Util.helperName(utype, true) + ".read (istream);");
        }
        index = utype.name().equals("boolean") ? this.readBoolean(disName, index, indent, name, u, stream) : this.readNonBoolean(disName, index, indent, name, u, stream);
        return index;
    }

    private int readBoolean(String disName, int index, String indent, String name, UnionEntry u, PrintWriter stream) {
        UnionBranch firstBranch = (UnionBranch)u.branches().firstElement();
        UnionBranch secondBranch = u.branches().size() == 2 ? (UnionBranch)u.branches().lastElement() : null;
        boolean firstBranchIsTrue = false;
        boolean noCases = false;
        try {
            if (u.branches().size() == 1 && (u.defaultBranch() != null || firstBranch.labels.size() == 2)) {
                noCases = true;
            } else {
                Expression expr = (Expression)firstBranch.labels.firstElement();
                Boolean bool = (Boolean)expr.evaluate();
                firstBranchIsTrue = bool;
            }
        }
        catch (EvaluationException expr) {
            // empty catch block
        }
        if (noCases) {
            index = this.readBranch(index, indent, firstBranch.typedef.name(), "", firstBranch.typedef, stream);
        } else {
            if (!firstBranchIsTrue) {
                UnionBranch tmp = firstBranch;
                firstBranch = secondBranch;
                secondBranch = tmp;
            }
            stream.println(indent + "if (" + disName + ")");
            if (firstBranch == null) {
                stream.println(indent + "  value._default(" + disName + ");");
            } else {
                stream.println(indent + "{");
                index = this.readBranch(index, indent + "  ", firstBranch.typedef.name(), disName, firstBranch.typedef, stream);
                stream.println(indent + "}");
            }
            stream.println(indent + "else");
            if (secondBranch == null) {
                stream.println(indent + "  value._default(" + disName + ");");
            } else {
                stream.println(indent + "{");
                index = this.readBranch(index, indent + "  ", secondBranch.typedef.name(), disName, secondBranch.typedef, stream);
                stream.println(indent + "}");
            }
        }
        return index;
    }

    private int readNonBoolean(String disName, int index, String indent, String name, UnionEntry u, PrintWriter stream) {
        SymtabEntry utype = Util.typeOf(u.type());
        if (utype instanceof EnumEntry) {
            stream.println(indent + "switch (" + disName + ".value ())");
        } else {
            stream.println(indent + "switch (" + disName + ")");
        }
        stream.println(indent + "{");
        String typePackage = Util.javaQualifiedName(utype) + ".";
        Enumeration e = u.branches().elements();
        while (e.hasMoreElements()) {
            UnionBranch branch = (UnionBranch)e.nextElement();
            Enumeration labels = branch.labels.elements();
            while (labels.hasMoreElements()) {
                Expression label = (Expression)labels.nextElement();
                if (utype instanceof EnumEntry) {
                    String key = Util.parseExpression(label);
                    stream.println(indent + "  case " + typePackage + "_" + key + ":");
                    continue;
                }
                stream.println(indent + "  case " + this.cast(label, utype) + ":");
            }
            if (branch.typedef.equals(u.defaultBranch())) continue;
            index = this.readBranch(index, indent + "    ", branch.typedef.name(), branch.labels.size() > 1 ? disName : "", branch.typedef, stream);
            stream.println(indent + "    break;");
        }
        if (!this.coversAll(u)) {
            stream.println(indent + "  default:");
            if (u.defaultBranch() == null) {
                stream.println(indent + "    value._default( " + disName + " ) ;");
            } else {
                index = this.readBranch(index, indent + "    ", u.defaultBranch().name(), disName, u.defaultBranch(), stream);
            }
            stream.println(indent + "    break;");
        }
        stream.println(indent + "}");
        return index;
    }

    private int readBranch(int index, String indent, String name, String disName, TypedefEntry entry, PrintWriter stream) {
        SymtabEntry type = entry.type();
        Util.writeInitializer(indent, "_" + name, "", entry, stream);
        if (!entry.arrayInfo().isEmpty() || type instanceof SequenceEntry || type instanceof PrimitiveEntry || type instanceof StringEntry) {
            index = ((JavaGenerator)((Object)entry.generator())).read(index, indent, "_" + name, entry, stream);
        } else {
            stream.println(indent + "_" + name + " = " + Util.helperName(type, true) + ".read (istream);");
        }
        stream.print(indent + "value." + name + " (");
        if (disName == "") {
            stream.println("_" + name + ");");
        } else {
            stream.println(disName + ", _" + name + ");");
        }
        return index;
    }

    @Override
    public int write(int index, String indent, String name, SymtabEntry entry, PrintWriter stream) {
        UnionEntry u = (UnionEntry)entry;
        SymtabEntry utype = Util.typeOf(u.type());
        if (utype instanceof PrimitiveEntry) {
            index = ((JavaGenerator)((Object)utype.generator())).write(index, indent, name + ".discriminator ()", utype, stream);
        } else {
            stream.println(indent + Util.helperName(utype, true) + ".write (ostream, " + name + ".discriminator ());");
        }
        index = utype.name().equals("boolean") ? this.writeBoolean(name + ".discriminator ()", index, indent, name, u, stream) : this.writeNonBoolean(name + ".discriminator ()", index, indent, name, u, stream);
        return index;
    }

    private int writeBoolean(String disName, int index, String indent, String name, UnionEntry u, PrintWriter stream) {
        SymtabEntry utype = Util.typeOf(u.type());
        UnionBranch firstBranch = (UnionBranch)u.branches().firstElement();
        UnionBranch secondBranch = u.branches().size() == 2 ? (UnionBranch)u.branches().lastElement() : null;
        boolean firstBranchIsTrue = false;
        boolean noCases = false;
        try {
            if (u.branches().size() == 1 && (u.defaultBranch() != null || firstBranch.labels.size() == 2)) {
                noCases = true;
            } else {
                firstBranchIsTrue = (Boolean)((Expression)firstBranch.labels.firstElement()).evaluate();
            }
        }
        catch (EvaluationException evaluationException) {
            // empty catch block
        }
        if (noCases) {
            index = this.writeBranch(index, indent, name, firstBranch.typedef, stream);
        } else {
            if (!firstBranchIsTrue) {
                UnionBranch tmp = firstBranch;
                firstBranch = secondBranch;
                secondBranch = tmp;
            }
            if (firstBranch != null && secondBranch != null) {
                stream.println(indent + "if (" + disName + ")");
                stream.println(indent + "{");
                index = this.writeBranch(index, indent + "  ", name, firstBranch.typedef, stream);
                stream.println(indent + "}");
                stream.println(indent + "else");
                stream.println(indent + "{");
                index = this.writeBranch(index, indent + "  ", name, secondBranch.typedef, stream);
                stream.println(indent + "}");
            } else if (firstBranch != null) {
                stream.println(indent + "if (" + disName + ")");
                stream.println(indent + "{");
                index = this.writeBranch(index, indent + "  ", name, firstBranch.typedef, stream);
                stream.println(indent + "}");
            } else {
                stream.println(indent + "if (!" + disName + ")");
                stream.println(indent + "{");
                index = this.writeBranch(index, indent + "  ", name, secondBranch.typedef, stream);
                stream.println(indent + "}");
            }
        }
        return index;
    }

    private int writeNonBoolean(String disName, int index, String indent, String name, UnionEntry u, PrintWriter stream) {
        SymtabEntry utype = Util.typeOf(u.type());
        if (utype instanceof EnumEntry) {
            stream.println(indent + "switch (" + name + ".discriminator ().value ())");
        } else {
            stream.println(indent + "switch (" + name + ".discriminator ())");
        }
        stream.println(indent + "{");
        String typePackage = Util.javaQualifiedName(utype) + ".";
        Enumeration e = u.branches().elements();
        while (e.hasMoreElements()) {
            UnionBranch branch = (UnionBranch)e.nextElement();
            Enumeration labels = branch.labels.elements();
            while (labels.hasMoreElements()) {
                Expression label = (Expression)labels.nextElement();
                if (utype instanceof EnumEntry) {
                    String key = Util.parseExpression(label);
                    stream.println(indent + "  case " + typePackage + "_" + key + ":");
                    continue;
                }
                stream.println(indent + "  case " + this.cast(label, utype) + ":");
            }
            if (branch.typedef.equals(u.defaultBranch())) continue;
            index = this.writeBranch(index, indent + "    ", name, branch.typedef, stream);
            stream.println(indent + "    break;");
        }
        if (u.defaultBranch() != null) {
            stream.println(indent + "  default:");
            index = this.writeBranch(index, indent + "    ", name, u.defaultBranch(), stream);
            stream.println(indent + "    break;");
        }
        stream.println(indent + "}");
        return index;
    }

    private int writeBranch(int index, String indent, String name, TypedefEntry entry, PrintWriter stream) {
        SymtabEntry type = entry.type();
        if (!entry.arrayInfo().isEmpty() || type instanceof SequenceEntry || type instanceof PrimitiveEntry || type instanceof StringEntry) {
            index = ((JavaGenerator)((Object)entry.generator())).write(index, indent, name + "." + entry.name() + " ()", entry, stream);
        } else {
            stream.println(indent + Util.helperName(type, true) + ".write (ostream, " + name + "." + entry.name() + " ());");
        }
        return index;
    }

    private String cast(Expression expr, SymtabEntry type) {
        Object ret = Util.parseExpression(expr);
        if (type.name().indexOf("short") >= 0) {
            int value;
            if (expr.value() instanceof Long) {
                long value2 = (Long)expr.value();
                if (value2 > 32767L) {
                    ret = "(short)(" + (String)ret + ")";
                }
            } else if (expr.value() instanceof Integer && (value = ((Integer)expr.value()).intValue()) > Short.MAX_VALUE) {
                ret = "(short)(" + (String)ret + ")";
            }
        } else if (type.name().indexOf("long") >= 0) {
            int value;
            if (expr.value() instanceof Long) {
                long value3 = (Long)expr.value();
                if (value3 > Integer.MAX_VALUE || value3 == Integer.MIN_VALUE) {
                    ret = "(int)(" + (String)ret + ")";
                }
            } else if (expr.value() instanceof Integer && ((value = ((Integer)expr.value()).intValue()) > Integer.MAX_VALUE || value == Integer.MIN_VALUE)) {
                ret = "(int)(" + (String)ret + ")";
            }
        }
        return ret;
    }
}

