/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.management;

import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.management.BaseNativeInterfaceResourceDefinition;
import org.jboss.as.controller.management.ManagementInterfaceAddStepHandler;
import org.jboss.as.controller.management.NativeInterfaceCommonPolicy;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.remoting3.RemotingOptions;
import org.xnio.OptionMap;

public abstract class BaseNativeInterfaceAddStepHandler
extends ManagementInterfaceAddStepHandler {
    @Override
    public void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        final String saslAuthenticationFactory = this.asStringIfDefined(context, BaseNativeInterfaceResourceDefinition.SASL_AUTHENTICATION_FACTORY, model);
        final String sslContext = this.asStringIfDefined(context, BaseNativeInterfaceResourceDefinition.SSL_CONTEXT, model);
        String serverName = this.asStringIfDefined(context, BaseNativeInterfaceResourceDefinition.SERVER_NAME, model);
        OptionMap.Builder builder = OptionMap.builder();
        builder.set(RemotingOptions.SASL_PROTOCOL, (Object)BaseNativeInterfaceResourceDefinition.SASL_PROTOCOL.resolveModelAttribute(context, model).asString());
        if (serverName != null) {
            builder.set(RemotingOptions.SERVER_NAME, (Object)serverName);
        }
        final OptionMap options = builder.getMap();
        List<ServiceName> requiredServices = this.installServices(context, new NativeInterfaceCommonPolicy(){

            @Override
            public String getSaslAuthenticationFactory() {
                return saslAuthenticationFactory;
            }

            @Override
            public String getSSLContext() {
                return sslContext;
            }

            @Override
            public OptionMap getConnectorOptions() {
                return options;
            }
        }, model);
        this.addVerifyInstallationStep(context, requiredServices);
    }

    protected abstract List<ServiceName> installServices(OperationContext var1, NativeInterfaceCommonPolicy var2, ModelNode var3) throws OperationFailedException;
}

