/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.predicate.Predicate;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.util.AttachmentKey;
import java.util.List;
import java.util.function.UnaryOperator;
import org.wildfly.extension.requestcontroller.ControlPoint;
import org.wildfly.extension.requestcontroller.RunResult;
import org.wildfly.extension.undertow.deployment.SuspendedServerHandler;

public class SuspendedServerHandlerWrapper
implements HandlerWrapper,
UnaryOperator<DeploymentInfo> {
    static final AttachmentKey<RunResult> RUN_RESULT_KEY = AttachmentKey.create(RunResult.class);
    private final ControlPoint entryPoint;
    private final List<Predicate> allowSuspendedRequests;

    public SuspendedServerHandlerWrapper(ControlPoint entryPoint, List<Predicate> allowSuspendedRequests) {
        this.entryPoint = entryPoint;
        this.allowSuspendedRequests = allowSuspendedRequests;
    }

    @Override
    public DeploymentInfo apply(DeploymentInfo deployment) {
        return deployment.addInitialHandlerChainWrapper((HandlerWrapper)this).addOuterHandlerChainWrapper(new HandlerWrapper(){

            public HttpHandler wrap(final HttpHandler handler) {
                return new HttpHandler(){

                    public void handleRequest(HttpServerExchange exchange) throws Exception {
                        if (exchange.getAttachment(RUN_RESULT_KEY) == RunResult.REJECTED) {
                            ((ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY)).getServletRequest().setAttribute("org.wildfly.suspended", (Object)"true");
                        }
                        handler.handleRequest(exchange);
                    }
                };
            }
        });
    }

    public HttpHandler wrap(final HttpHandler handler) {
        final ControlPoint entryPoint = this.entryPoint;
        return new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                if (exchange.putAttachment(RUN_RESULT_KEY, (Object)entryPoint.beginRequest()) == RunResult.RUN) {
                    entryPoint.requestComplete();
                }
                if (exchange.getAttachment(RUN_RESULT_KEY) == RunResult.RUN || SuspendedServerHandlerWrapper.this.allowSuspendedRequest(exchange)) {
                    handler.handleRequest(exchange);
                } else {
                    SuspendedServerHandler.DEFAULT.handleRequest(exchange);
                }
            }
        };
    }

    boolean allowSuspendedRequest(HttpServerExchange exchange) {
        for (Predicate predicate : this.allowSuspendedRequests) {
            if (!predicate.resolve(exchange)) continue;
            return true;
        }
        return false;
    }
}

