/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeChangeNotification;
import javax.management.Descriptor;
import javax.management.ImmutableDescriptor;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenMBeanConstructorInfo;
import javax.management.openmbean.OpenMBeanInfoSupport;
import javax.management.openmbean.OpenMBeanOperationInfo;
import javax.management.openmbean.OpenMBeanOperationInfoSupport;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenMBeanParameterInfoSupport;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularType;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.NotificationEntry;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.jmx.logging.JmxLogger;
import org.jboss.as.jmx.model.ChildAddOperationFinder;
import org.jboss.as.jmx.model.ConfiguredDomains;
import org.jboss.as.jmx.model.ModelControllerMBeanHelper;
import org.jboss.as.jmx.model.MutabilityChecker;
import org.jboss.as.jmx.model.NameConverter;
import org.jboss.as.jmx.model.TypeConverters;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class MBeanInfoFactory {
    private static final String DESC_MBEAN_EXPR = "mbean.expression.support";
    private static final String DESC_MBEAN_EXPR_DESCR = "mbean.expression.support.description";
    private static final String DESC_ALTERNATE_MBEAN = "alternate.mbean";
    private static final String DESC_ALTERNATE_MBEAN_DESCR = "alternate.mbean.description";
    private static final String DESC_EXPRESSIONS_ALLOWED = "expressions.allowed";
    private static final String DESC_EXPRESSIONS_ALLOWED_DESC = "expressions.allowed.description";
    private static final OpenMBeanParameterInfo[] EMPTY_PARAMETERS = new OpenMBeanParameterInfo[0];
    private final ObjectName name;
    private final TypeConverters converters;
    private final ConfiguredDomains configuredDomains;
    private final MutabilityChecker mutabilityChecker;
    private final ImmutableManagementResourceRegistration resourceRegistration;
    private final ModelNode providedDescription;
    private final PathAddress pathAddress;
    private final boolean legacy;

    private MBeanInfoFactory(ObjectName name, TypeConverters converters, ConfiguredDomains configuredDomains, MutabilityChecker mutabilityChecker, PathAddress address, ImmutableManagementResourceRegistration resourceRegistration) {
        this.name = name;
        this.converters = converters;
        this.configuredDomains = configuredDomains;
        this.mutabilityChecker = mutabilityChecker;
        this.legacy = configuredDomains.isLegacyDomain(name);
        this.resourceRegistration = resourceRegistration;
        DescriptionProvider provider = resourceRegistration.getModelDescription(PathAddress.EMPTY_ADDRESS);
        this.providedDescription = provider != null ? provider.getModelDescription(null) : new ModelNode();
        this.pathAddress = address;
    }

    static MBeanInfo createMBeanInfo(ObjectName name, TypeConverters converters, ConfiguredDomains configuredDomains, MutabilityChecker mutabilityChecker, PathAddress address, ImmutableManagementResourceRegistration resourceRegistration) throws InstanceNotFoundException {
        return new MBeanInfoFactory(name, converters, configuredDomains, mutabilityChecker, address, resourceRegistration).createMBeanInfo();
    }

    private MBeanInfo createMBeanInfo() {
        return new OpenMBeanInfoSupport(ModelControllerMBeanHelper.CLASS_NAME, this.getDescription(this.providedDescription), this.getAttributes(), this.getConstructors(), this.getOperations(), this.getNotifications(), this.createMBeanDescriptor());
    }

    private String getDescription(ModelNode node) {
        if (!node.hasDefined("description")) {
            return "-";
        }
        String description = node.get("description").asString();
        if (description.trim().length() == 0) {
            return "-";
        }
        return description;
    }

    private OpenMBeanAttributeInfo[] getAttributes() {
        LinkedList<OpenMBeanAttributeInfo> infos = new LinkedList<OpenMBeanAttributeInfo>();
        if (this.providedDescription.hasDefined("attributes")) {
            for (String name : this.providedDescription.require("attributes").keys()) {
                OpenMBeanAttributeInfo attributeInfo = this.getAttribute(name);
                if (attributeInfo == null) continue;
                infos.add(this.getAttribute(name));
            }
        }
        return infos.toArray(new OpenMBeanAttributeInfo[infos.size()]);
    }

    private OpenMBeanAttributeInfo getAttribute(String name) {
        String escapedName = NameConverter.convertToCamelCase(name);
        ModelNode attribute = this.providedDescription.require("attributes").require(name);
        AttributeAccess access = this.resourceRegistration.getAttributeAccess(PathAddress.EMPTY_ADDRESS, name);
        if (access == null) {
            return null;
        }
        boolean writable = this.mutabilityChecker.mutable(this.pathAddress) && access.getAccessType() == AttributeAccess.AccessType.READ_WRITE;
        return new OpenMBeanAttributeInfoSupport(escapedName, this.getDescription(attribute), this.converters.convertToMBeanType(access.getAttributeDefinition(), attribute), true, writable, false, this.createAttributeDescriptor(attribute));
    }

    private OpenMBeanConstructorInfo[] getConstructors() {
        return null;
    }

    private OpenMBeanOperationInfo[] getOperations() {
        boolean root = this.pathAddress.size() == 0;
        ArrayList<OpenMBeanOperationInfo> ops = new ArrayList<OpenMBeanOperationInfo>();
        for (Map.Entry entry : this.resourceRegistration.getOperationDescriptions(PathAddress.EMPTY_ADDRESS, false).entrySet()) {
            String opName = (String)entry.getKey();
            if (opName.equals("add") || opName.equals("describe") || root && (opName.equals("read-resource") || opName.equals("read-attribute") || opName.equals("read-resource-description") || opName.equals("read-children-names") || opName.equals("read-children-types") || opName.equals("read-children-resources") || opName.equals("read-operation-names") || opName.equals("read-operation-description") || opName.equals("write-attribute") || opName.equals("validate-address") || opName.equals("composite") || opName.equals("upload-deployment-stream"))) continue;
            OperationEntry opEntry = (OperationEntry)entry.getValue();
            if (!this.mutabilityChecker.mutable(this.pathAddress) && !opEntry.getFlags().contains(OperationEntry.Flag.READ_ONLY) && !opEntry.getFlags().contains(OperationEntry.Flag.RUNTIME_ONLY)) continue;
            ops.add(this.getOperation(NameConverter.convertToCamelCase((String)entry.getKey()), null, opEntry));
        }
        this.addChildAddOperations(ops, this.resourceRegistration);
        return ops.toArray(new OpenMBeanOperationInfo[ops.size()]);
    }

    private void addChildAddOperations(List<OpenMBeanOperationInfo> ops, ImmutableManagementResourceRegistration resourceRegistration) {
        for (Map.Entry<PathElement, ChildAddOperationFinder.ChildAddOperationEntry> entry : ChildAddOperationFinder.findAddChildOperations(this.pathAddress, this.mutabilityChecker, resourceRegistration).entrySet()) {
            OpenMBeanParameterInfoSupport addWildcardChildName = null;
            if (entry.getValue().getElement().isWildcard()) {
                addWildcardChildName = new OpenMBeanParameterInfoSupport("name", "The name of the " + entry.getValue().getElement().getKey() + " to add.", SimpleType.STRING);
            }
            ops.add(this.getOperation(NameConverter.createValidAddOperationName(entry.getKey()), addWildcardChildName, entry.getValue().getOperationEntry()));
        }
    }

    private OpenMBeanOperationInfo getOperation(String name, OpenMBeanParameterInfo addWildcardChildName, OperationEntry entry) {
        ModelNode opNode = entry.getDescriptionProvider().getModelDescription(null);
        OpenMBeanParameterInfo[] params = this.getParameterInfos(entry.getOperationDefinition(), opNode);
        if (addWildcardChildName != null) {
            OpenMBeanParameterInfo[] newParams = new OpenMBeanParameterInfo[params.length + 1];
            newParams[0] = addWildcardChildName;
            System.arraycopy(params, 0, newParams, 1, params.length);
            params = newParams;
        }
        return new OpenMBeanOperationInfoSupport(name, this.getDescription(opNode), params, this.getReturnType(opNode), entry.getFlags().contains(OperationEntry.Flag.READ_ONLY) ? 0 : 3, this.createOperationDescriptor());
    }

    private OpenMBeanParameterInfo[] getParameterInfos(OperationDefinition opDef, ModelNode opNode) {
        if (!opNode.hasDefined("request-properties")) {
            return EMPTY_PARAMETERS;
        }
        List propertyList = opNode.get("request-properties").asPropertyList();
        ArrayList<OpenMBeanParameterInfoSupport> params = new ArrayList<OpenMBeanParameterInfoSupport>(propertyList.size());
        HashMap<String, Object> attributeDefinitions = new HashMap<String, Object>();
        AttributeDefinition[] attrs = opDef.getParameters();
        if (attrs != null) {
            for (AttributeDefinition attributeDefinition : attrs) {
                attributeDefinitions.put(attributeDefinition.getName(), attributeDefinition);
            }
        }
        for (Property prop : propertyList) {
            String name = prop.getName();
            ModelNode value = prop.getValue();
            AttributeDefinition attributeDefinition = (AttributeDefinition)attributeDefinitions.get(name);
            String paramName = NameConverter.convertToCamelCase(name);
            HashMap<String, Object> descriptions = new HashMap<String, Object>(4);
            boolean expressionsAllowed = value.hasDefined("expressions-allowed") && value.get("expressions-allowed").asBoolean();
            descriptions.put(DESC_EXPRESSIONS_ALLOWED, String.valueOf(expressionsAllowed));
            OpenType<?> mbeanType = this.converters.convertToMBeanType(attributeDefinition, value);
            if (!expressionsAllowed) {
                Object defaultValue = this.getIfExists(attributeDefinition, value, "default");
                if (!mbeanType.isArray() && !(mbeanType instanceof TabularType)) {
                    descriptions.put("defaultValue", defaultValue);
                }
                if (value.has("allowed")) {
                    if (value.get("type").asType() != ModelType.LIST) {
                        List allowed = value.get("allowed").asList();
                        descriptions.put("legalValues", this.fromModelNodes(allowed));
                    }
                } else {
                    Comparable<?> maxC;
                    Comparable<?> minC;
                    if (value.has("min") && (minC = this.getIfExistsAsComparable(attributeDefinition, value, "min")) instanceof Number) {
                        descriptions.put("minValue", minC);
                    }
                    if (value.has("max") && (maxC = this.getIfExistsAsComparable(attributeDefinition, value, "max")) instanceof Number) {
                        descriptions.put("maxValue", maxC);
                    }
                }
            }
            params.add(new OpenMBeanParameterInfoSupport(paramName, this.getDescription(value), mbeanType, new ImmutableDescriptor(descriptions)));
        }
        return params.toArray(new OpenMBeanParameterInfo[params.size()]);
    }

    private Set<?> fromModelNodes(List<ModelNode> nodes) {
        HashSet<Object> values = new HashSet<Object>(nodes.size());
        for (ModelNode node : nodes) {
            values.add(this.converters.getConverter(null, ModelType.STRING, null).fromModelNode(node));
        }
        return values;
    }

    private Object getIfExists(AttributeDefinition attributeDefinition, ModelNode parentNode, String name) {
        if (parentNode.has(name)) {
            ModelNode defaultNode = parentNode.get(name);
            return this.converters.fromModelNode(attributeDefinition, parentNode, defaultNode);
        }
        return null;
    }

    private Comparable<?> getIfExistsAsComparable(AttributeDefinition attributeDefinition, ModelNode parentNode, String name) {
        ModelNode defaultNode;
        Object value;
        if (parentNode.has(name) && (value = this.converters.fromModelNode(attributeDefinition, parentNode, defaultNode = parentNode.get(name))) instanceof Comparable) {
            return (Comparable)value;
        }
        return null;
    }

    private OpenType<?> getReturnType(ModelNode opNode) {
        if (!opNode.hasDefined("reply-properties")) {
            return SimpleType.VOID;
        }
        if (opNode.get("reply-properties").asList().isEmpty()) {
            return SimpleType.VOID;
        }
        ModelNode reply = opNode.get("reply-properties");
        return this.converters.convertToMBeanType(null, reply);
    }

    private MBeanNotificationInfo[] getNotifications() {
        ArrayList<MBeanNotificationInfo> notifications = new ArrayList<MBeanNotificationInfo>();
        for (Map.Entry entry : this.resourceRegistration.getNotificationDescriptions(PathAddress.EMPTY_ADDRESS, true).entrySet()) {
            ModelNode descriptionModel = ((NotificationEntry)entry.getValue()).getDescriptionProvider().getModelDescription(null);
            String description = descriptionModel.get("description").asString();
            String notificationType = (String)entry.getKey();
            MBeanNotificationInfo info = null;
            if (notificationType.equals("attribute-value-written")) {
                info = new MBeanNotificationInfo(new String[]{"jmx.attribute.change"}, AttributeChangeNotification.class.getName(), description);
            } else if (!notificationType.equals("resource-added") && !notificationType.equals("resource-removed")) {
                info = new MBeanNotificationInfo(new String[]{notificationType}, Notification.class.getName(), description);
            }
            if (info == null) continue;
            notifications.add(info);
        }
        return notifications.toArray(new MBeanNotificationInfo[notifications.size()]);
    }

    private Descriptor createMBeanDescriptor() {
        HashMap<String, String> descriptions = new HashMap<String, String>();
        this.addMBeanExpressionSupport(descriptions);
        return new ImmutableDescriptor(descriptions);
    }

    private Descriptor createAttributeDescriptor(ModelNode attribute) {
        HashMap<String, String> descriptions = new HashMap<String, String>();
        this.addMBeanExpressionSupport(descriptions);
        boolean allowExpressions = attribute.hasDefined("expressions-allowed") && attribute.get("expressions-allowed").asBoolean();
        descriptions.put(DESC_EXPRESSIONS_ALLOWED, Boolean.toString(allowExpressions));
        descriptions.put(DESC_EXPRESSIONS_ALLOWED_DESC, allowExpressions ? JmxLogger.ROOT_LOGGER.descriptorAttributeExpressionsAllowedTrue() : JmxLogger.ROOT_LOGGER.descriptorAttributeExpressionsAllowedFalse());
        return new ImmutableDescriptor(descriptions);
    }

    private Descriptor createOperationDescriptor() {
        HashMap<String, String> descriptions = new HashMap<String, String>();
        this.addMBeanExpressionSupport(descriptions);
        return new ImmutableDescriptor(descriptions);
    }

    private void addMBeanExpressionSupport(Map<String, String> descriptions) {
        if (this.legacy) {
            descriptions.put(DESC_MBEAN_EXPR, "true");
            descriptions.put(DESC_MBEAN_EXPR_DESCR, JmxLogger.ROOT_LOGGER.descriptorMBeanExpressionSupportFalse());
            if (this.configuredDomains.getExprDomain() != null) {
                ObjectName alternate = this.configuredDomains.getMirroredObjectName(this.name);
                descriptions.put(DESC_ALTERNATE_MBEAN, alternate.toString());
                descriptions.put(DESC_ALTERNATE_MBEAN_DESCR, JmxLogger.ROOT_LOGGER.descriptorAlternateMBeanExpressions(alternate));
            }
        } else {
            descriptions.put(DESC_MBEAN_EXPR, "false");
            descriptions.put(DESC_MBEAN_EXPR_DESCR, JmxLogger.ROOT_LOGGER.descriptorMBeanExpressionSupportTrue());
            if (this.configuredDomains.getLegacyDomain() != null) {
                ObjectName alternate = this.configuredDomains.getMirroredObjectName(this.name);
                descriptions.put(DESC_ALTERNATE_MBEAN, alternate.toString());
                descriptions.put(DESC_ALTERNATE_MBEAN_DESCR, JmxLogger.ROOT_LOGGER.descriptorAlternateMBeanLegacy(alternate));
            }
        }
    }
}

