/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.client.producer.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.kafka.client.common.KafkaClientOptions;
import io.vertx.kafka.client.common.tracing.ProducerTracer;
import io.vertx.kafka.client.producer.KafkaWriteStream;
import java.time.Duration;
import java.util.List;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.PartitionInfo;

public class KafkaWriteStreamImpl<K, V>
implements KafkaWriteStream<K, V> {
    private long maxSize = 0x100000L;
    private long pending;
    private final Producer<K, V> producer;
    private Handler<Void> drainHandler;
    private Handler<Throwable> exceptionHandler;
    private final VertxInternal vertx;
    private final ProducerTracer tracer;
    private final TaskQueue taskQueue;

    public KafkaWriteStreamImpl(Vertx vertx, Producer<K, V> producer, KafkaClientOptions options) {
        ContextInternal ctxInt = ((ContextInternal)vertx.getOrCreateContext()).unwrap();
        this.producer = producer;
        this.vertx = (VertxInternal)vertx;
        this.tracer = ProducerTracer.create(ctxInt.tracer(), options);
        this.taskQueue = new TaskQueue();
    }

    private int len(Object value) {
        if (value instanceof byte[]) {
            return ((byte[])value).length;
        }
        if (value instanceof String) {
            return ((String)value).length();
        }
        return 1;
    }

    @Override
    public Future<RecordMetadata> send(ProducerRecord<K, V> record) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        ProducerTracer.StartedSpan startedSpan = this.tracer == null ? null : this.tracer.prepareSendMessage((Context)ctx, record);
        int len = this.len(record.value());
        this.pending += (long)len;
        return ctx.executeBlocking(prom -> {
            try {
                this.producer.send(record, (metadata, err) -> {
                    ctx.runOnContext(v1 -> {
                        KafkaWriteStreamImpl kafkaWriteStreamImpl = this;
                        synchronized (kafkaWriteStreamImpl) {
                            if (err != null && this.exceptionHandler != null) {
                                Handler<Throwable> exceptionHandler = this.exceptionHandler;
                                ctx.runOnContext(v2 -> exceptionHandler.handle((Object)err));
                            }
                            long lowWaterMark = this.maxSize / 2L;
                            this.pending -= (long)len;
                            if (this.pending < lowWaterMark && this.drainHandler != null) {
                                Handler<Void> drainHandler = this.drainHandler;
                                this.drainHandler = null;
                                ctx.runOnContext(drainHandler);
                            }
                        }
                    });
                    if (err != null) {
                        if (startedSpan != null) {
                            startedSpan.fail((Context)ctx, err);
                        }
                        prom.fail((Throwable)err);
                    } else {
                        if (startedSpan != null) {
                            startedSpan.finish((Context)ctx);
                        }
                        prom.complete((Object)metadata);
                    }
                });
            }
            catch (Throwable e) {
                KafkaWriteStreamImpl kafkaWriteStreamImpl = this;
                synchronized (kafkaWriteStreamImpl) {
                    if (this.exceptionHandler != null) {
                        Handler<Throwable> exceptionHandler = this.exceptionHandler;
                        ctx.runOnContext(v3 -> exceptionHandler.handle((Object)e));
                    }
                }
                if (startedSpan != null) {
                    startedSpan.fail((Context)ctx, e);
                }
                prom.fail(e);
            }
        }, this.taskQueue);
    }

    @Override
    public synchronized KafkaWriteStreamImpl<K, V> send(ProducerRecord<K, V> record, Handler<AsyncResult<RecordMetadata>> handler) {
        this.send(record).onComplete(handler);
        return this;
    }

    public void write(ProducerRecord<K, V> data, Handler<AsyncResult<Void>> handler) {
        this.write(data).onComplete(handler);
    }

    public Future<Void> write(ProducerRecord<K, V> record) {
        return this.send(record).mapEmpty();
    }

    @Override
    public KafkaWriteStreamImpl<K, V> setWriteQueueMaxSize(int size) {
        this.maxSize = size;
        return this;
    }

    public synchronized boolean writeQueueFull() {
        return this.pending >= this.maxSize;
    }

    @Override
    public synchronized KafkaWriteStreamImpl<K, V> drainHandler(Handler<Void> handler) {
        this.drainHandler = handler;
        return this;
    }

    public void end(Handler<AsyncResult<Void>> handler) {
        if (handler != null) {
            this.vertx.runOnContext(v -> handler.handle((Object)Future.succeededFuture()));
        }
    }

    @Override
    public KafkaWriteStream<K, V> initTransactions(Handler<AsyncResult<Void>> handler) {
        this.initTransactions().onComplete(handler);
        return this;
    }

    @Override
    public Future<Void> initTransactions() {
        return this.executeBlocking(() -> this.producer.initTransactions());
    }

    @Override
    public KafkaWriteStream<K, V> beginTransaction(Handler<AsyncResult<Void>> handler) {
        this.beginTransaction().onComplete(handler);
        return this;
    }

    @Override
    public Future<Void> beginTransaction() {
        return this.executeBlocking(() -> this.producer.beginTransaction());
    }

    @Override
    public KafkaWriteStream<K, V> commitTransaction(Handler<AsyncResult<Void>> handler) {
        this.commitTransaction().onComplete(handler);
        return this;
    }

    @Override
    public Future<Void> commitTransaction() {
        return this.executeBlocking(() -> this.producer.commitTransaction());
    }

    @Override
    public KafkaWriteStream<K, V> abortTransaction(Handler<AsyncResult<Void>> handler) {
        this.abortTransaction().onComplete(handler);
        return this;
    }

    @Override
    public Future<Void> abortTransaction() {
        return this.executeBlocking(() -> this.producer.abortTransaction());
    }

    @Override
    public KafkaWriteStreamImpl<K, V> exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public Future<List<PartitionInfo>> partitionsFor(String topic) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        PromiseInternal trampolineProm = ctx.promise();
        this.vertx.setTimer(2000L, arg_0 -> KafkaWriteStreamImpl.lambda$partitionsFor$6((Promise)trampolineProm, arg_0));
        ctx.executeBlocking(prom -> prom.complete((Object)this.producer.partitionsFor(topic)), this.taskQueue).onComplete((Handler)trampolineProm);
        return trampolineProm.future();
    }

    @Override
    public KafkaWriteStreamImpl<K, V> partitionsFor(String topic, Handler<AsyncResult<List<PartitionInfo>>> handler) {
        this.partitionsFor(topic).onComplete(handler);
        return this;
    }

    @Override
    public Future<Void> flush() {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        return ctx.executeBlocking(prom -> {
            this.producer.flush();
            prom.complete();
        }, this.taskQueue);
    }

    @Override
    public KafkaWriteStreamImpl<K, V> flush(Handler<AsyncResult<Void>> completionHandler) {
        this.flush().onComplete(completionHandler);
        return this;
    }

    @Override
    public Future<Void> close() {
        return this.close(0L);
    }

    @Override
    public void close(Handler<AsyncResult<Void>> completionHandler) {
        this.close(0L, completionHandler);
    }

    @Override
    public Future<Void> close(long timeout) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        PromiseInternal trampolineProm = ctx.promise();
        return ctx.executeBlocking(prom -> {
            if (timeout > 0L) {
                this.producer.close(Duration.ofMillis(timeout));
            } else {
                this.producer.close();
            }
            prom.complete();
        }, this.taskQueue);
    }

    @Override
    public void close(long timeout, Handler<AsyncResult<Void>> completionHandler) {
        this.close(timeout).onComplete(completionHandler);
    }

    @Override
    public Producer<K, V> unwrap() {
        return this.producer;
    }

    Future<Void> executeBlocking(BlockingStatement statement) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        return ctx.executeBlocking(promise -> {
            try {
                statement.execute();
                promise.complete();
            }
            catch (Exception e) {
                promise.fail((Throwable)e);
            }
        }, this.taskQueue);
    }

    private static /* synthetic */ void lambda$partitionsFor$6(Promise trampolineProm, Long id) {
        trampolineProm.tryFail("Kafka connect timeout");
    }

    @FunctionalInterface
    private static interface BlockingStatement {
        public void execute();
    }
}

