/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.remote.user;

import java.util.function.Supplier;
import org.wildfly.clustering.cache.infinispan.remote.RemoteCacheConfiguration;
import org.wildfly.clustering.marshalling.ByteBufferMarshalledValueFactory;
import org.wildfly.clustering.marshalling.MarshalledValueFactory;
import org.wildfly.clustering.marshalling.MarshalledValueMarshaller;
import org.wildfly.clustering.server.local.manager.SimpleIdentifierFactoryService;
import org.wildfly.clustering.server.manager.IdentifierFactoryService;
import org.wildfly.clustering.session.cache.user.CompositeUserFactory;
import org.wildfly.clustering.session.cache.user.DefaultUserManager;
import org.wildfly.clustering.session.cache.user.UserFactory;
import org.wildfly.clustering.session.infinispan.remote.user.HotRodUserContextFactory;
import org.wildfly.clustering.session.infinispan.remote.user.HotRodUserSessionsFactory;
import org.wildfly.clustering.session.user.UserManager;
import org.wildfly.clustering.session.user.UserManagerConfiguration;
import org.wildfly.clustering.session.user.UserManagerFactory;

public class HotRodUserManagerFactory<C, D, S>
implements UserManagerFactory<C, D, S> {
    private final RemoteCacheConfiguration configuration;

    public HotRodUserManagerFactory(RemoteCacheConfiguration configuration) {
        this.configuration = configuration;
    }

    public <T> UserManager<C, T, D, S> createUserManager(UserManagerConfiguration<T> configuration) {
        MarshalledValueMarshaller marshaller = new MarshalledValueMarshaller((MarshalledValueFactory)new ByteBufferMarshalledValueFactory(configuration.getMarshaller()));
        HotRodUserContextFactory contextFactory = new HotRodUserContextFactory(this.configuration, marshaller, configuration.getTransientContextFactory());
        HotRodUserSessionsFactory sessionsFactory = new HotRodUserSessionsFactory(this.configuration);
        CompositeUserFactory factory = new CompositeUserFactory(contextFactory, sessionsFactory, this.configuration.getCacheProperties());
        SimpleIdentifierFactoryService identifierFactory = new SimpleIdentifierFactoryService((Supplier)configuration.getIdentifierFactory());
        return new DefaultUserManager((UserFactory)factory, (IdentifierFactoryService)identifierFactory, this.configuration.getBatchFactory());
    }
}

