/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.infinispan.provider;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.infinispan.embedded.EmbeddedCacheConfiguration;
import org.wildfly.clustering.cache.infinispan.embedded.distribution.CacheStreamFilter;
import org.wildfly.clustering.context.DefaultExecutorService;
import org.wildfly.clustering.function.Supplier;
import org.wildfly.clustering.server.infinispan.CacheContainerGroup;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMember;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMemberFactory;
import org.wildfly.clustering.server.infinispan.provider.AddressSetAddFunction;
import org.wildfly.clustering.server.infinispan.provider.AddressSetRemoveFunction;
import org.wildfly.clustering.server.infinispan.provider.CacheContainerServiceProviderRegistrar;
import org.wildfly.clustering.server.local.provider.DefaultServiceProviderRegistration;
import org.wildfly.clustering.server.provider.ServiceProviderRegistrar;
import org.wildfly.clustering.server.provider.ServiceProviderRegistration;
import org.wildfly.clustering.server.provider.ServiceProviderRegistrationEvent;
import org.wildfly.clustering.server.provider.ServiceProviderRegistrationListener;

@Listener(observation=Listener.Observation.POST)
public class CacheServiceProviderRegistrar<T>
implements CacheContainerServiceProviderRegistrar<T>,
AutoCloseable {
    private static final System.Logger LOGGER = System.getLogger(CacheServiceProviderRegistrar.class.getName());
    private final Supplier<Batch> batchFactory;
    private final ConcurrentMap<T, Map.Entry<ServiceProviderRegistrationListener<CacheContainerGroupMember>, ExecutorService>> listeners = new ConcurrentHashMap<T, Map.Entry<ServiceProviderRegistrationListener<CacheContainerGroupMember>, ExecutorService>>();
    private final Cache<T, Set<Address>> cache;
    private final BooleanSupplier active;
    private final CacheContainerGroup group;
    private final Executor executor;

    public CacheServiceProviderRegistrar(Configuration configuration) {
        this.group = configuration.getGroup();
        this.cache = configuration.getWriteOnlyCache();
        this.batchFactory = configuration.getBatchFactory();
        this.executor = configuration.getExecutor();
        this.active = () -> ((Configuration)configuration).isActive();
        this.cache.addListener((Object)this);
    }

    @Override
    public void close() {
        this.cache.removeListener((Object)this);
        for (Object service : this.listeners.keySet()) {
            this.unregisterLocal(service);
        }
    }

    private void shutdown(final ExecutorService executor) {
        PrivilegedAction<Void> action = new PrivilegedAction<Void>(this){
            final /* synthetic */ CacheServiceProviderRegistrar this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Void run() {
                executor.shutdown();
                return null;
            }
        };
        AccessController.doPrivileged(action);
        try {
            executor.awaitTermination(this.cache.getCacheConfiguration().transaction().cacheStopTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public CacheContainerGroup getGroup() {
        return this.group;
    }

    public ServiceProviderRegistration<T, CacheContainerGroupMember> register(T service) {
        ServiceProviderRegistrationListener<CacheContainerGroupMember> listener = null;
        return this.register(service, listener);
    }

    public ServiceProviderRegistration<T, CacheContainerGroupMember> register(T service, ServiceProviderRegistrationListener<CacheContainerGroupMember> listener) {
        AbstractMap.SimpleEntry<ServiceProviderRegistrationListener<CacheContainerGroupMember>, Object> newEntry = new AbstractMap.SimpleEntry<ServiceProviderRegistrationListener<CacheContainerGroupMember>, Object>(listener, null);
        Map.Entry entry = this.listeners.computeIfAbsent(service, key -> {
            if (listener != null) {
                newEntry.setValue(new DefaultExecutorService(Executors::newSingleThreadExecutor, Thread.currentThread().getContextClassLoader()));
            }
            return newEntry;
        });
        if (entry != newEntry) {
            throw new IllegalArgumentException(service.toString());
        }
        if (this.active.getAsBoolean()) {
            this.registerLocalMember(service);
        }
        return new DefaultServiceProviderRegistration((ServiceProviderRegistrar)this, service, () -> this.unregisterLocal(service));
    }

    void registerLocalMember(T service) {
        Address localAddress = this.cache.getCacheManager().getAddress();
        try (Batch batch = (Batch)this.batchFactory.get();){
            this.registerMember(service, localAddress);
        }
    }

    void registerMember(T service, Address address) {
        this.cache.compute(service, (BiFunction)((Object)new AddressSetAddFunction(address)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterLocal(T service) {
        try {
            Address localAddress = this.cache.getCacheManager().getAddress();
            try (Batch batch = (Batch)this.batchFactory.get();){
                this.unregister(service, Set.of(localAddress));
            }
        }
        finally {
            ExecutorService executor;
            Map.Entry oldEntry = (Map.Entry)this.listeners.remove(service);
            if (oldEntry != null && (executor = (ExecutorService)oldEntry.getValue()) != null) {
                this.shutdown(executor);
            }
        }
    }

    void unregister(T service, Set<Address> addresses) {
        this.cache.compute(service, (BiFunction)((Object)new AddressSetRemoveFunction(addresses)));
    }

    public Set<CacheContainerGroupMember> getProviders(T service) {
        Set addresses = (Set)this.cache.get(service);
        return addresses != null ? this.map(addresses) : Set.of();
    }

    public Set<T> getServices() {
        return this.cache.keySet();
    }

    private Set<CacheContainerGroupMember> map(Set<Address> addresses) {
        return addresses.stream().map(arg_0 -> ((CacheContainerGroupMemberFactory)this.group.getGroupMemberFactory()).createGroupMember(arg_0)).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
    }

    @TopologyChanged
    public CompletionStage<Void> topologyChanged(TopologyChangedEvent<T, Set<Address>> event) {
        if (this.group.isSingleton()) {
            return CompletableFuture.completedStage(null);
        }
        ConsistentHash previousHash = event.getWriteConsistentHashAtStart();
        List previousMembers = previousHash.getMembers();
        ConsistentHash hash = event.getWriteConsistentHashAtEnd();
        List members = hash.getMembers();
        if (!members.equals(previousMembers)) {
            Set localServices;
            Cache cache = event.getCache();
            Address localAddress = cache.getCacheManager().getAddress();
            HashSet leftMembers = new HashSet(previousMembers);
            leftMembers.removeAll(members);
            Set<Object> set = localServices = !previousMembers.contains(localAddress) ? this.listeners.keySet() : Set.of();
            if (!leftMembers.isEmpty() || !localServices.isEmpty()) {
                try {
                    this.executor.execute(() -> {
                        if (!leftMembers.isEmpty()) {
                            try (Batch batch = (Batch)this.batchFactory.get();){
                                CacheStreamFilter filter = CacheStreamFilter.primary((ConsistentHash)hash, (Address)localAddress);
                                try (Stream stream = (Stream)filter.apply((Object)cache.keySet().stream());){
                                    Iterator keys = stream.iterator();
                                    while (keys.hasNext()) {
                                        this.unregister(keys.next(), leftMembers);
                                    }
                                }
                            }
                        }
                        if (!localServices.isEmpty() && this.active.getAsBoolean()) {
                            for (Object localService : localServices) {
                                this.registerLocalMember(localService);
                            }
                        }
                    });
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
        }
        return CompletableFuture.completedStage(null);
    }

    @CacheEntryCreated
    public CompletionStage<Void> created(CacheEntryCreatedEvent<T, Set<Address>> event) {
        return this.updated(event.getKey(), Set.of(), (Set)event.getValue());
    }

    @CacheEntryModified
    public CompletionStage<Void> modified(CacheEntryModifiedEvent<T, Set<Address>> event) {
        return !Objects.equals(event.getOldValue(), event.getNewValue()) ? this.updated(event.getKey(), (Set)event.getOldValue(), (Set)event.getNewValue()) : CompletableFuture.completedFuture(null);
    }

    private CompletionStage<Void> updated(T service, Set<Address> previousProviders, Set<Address> currentProviders) {
        ServiceProviderRegistrationListener listener;
        Map.Entry entry = (Map.Entry)this.listeners.get(service);
        if (entry != null && (listener = (ServiceProviderRegistrationListener)entry.getKey()) != null) {
            Executor executor = (Executor)entry.getValue();
            final Set<CacheContainerGroupMember> previousMembers = this.map(previousProviders);
            final Set<CacheContainerGroupMember> currentMembers = this.map(currentProviders);
            ServiceProviderRegistrationEvent<CacheContainerGroupMember> event = new ServiceProviderRegistrationEvent<CacheContainerGroupMember>(this){
                final /* synthetic */ CacheServiceProviderRegistrar this$0;
                {
                    this.this$0 = this$0;
                }

                public Set<CacheContainerGroupMember> getPreviousProviders() {
                    return previousMembers;
                }

                public Set<CacheContainerGroupMember> getCurrentProviders() {
                    return currentMembers;
                }
            };
            try {
                executor.execute(() -> CacheServiceProviderRegistrar.lambda$updated$0(listener, (ServiceProviderRegistrationEvent)event));
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
        return CompletableFuture.completedStage(null);
    }

    private static /* synthetic */ void lambda$updated$0(ServiceProviderRegistrationListener listener, ServiceProviderRegistrationEvent event) {
        try {
            listener.providersChanged(event);
        }
        catch (Throwable e) {
            LOGGER.log(System.Logger.Level.WARNING, e.getLocalizedMessage(), e);
        }
    }

    public static interface Configuration
    extends EmbeddedCacheConfiguration {
        public CacheContainerGroup getGroup();
    }
}

