/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.Map;
import java.util.function.Supplier;
import org.jboss.as.connector.subsystems.datasources.ModifiableDataSource;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class DataSourceConfigService
implements Service<ModifiableDataSource> {
    public static final ServiceName SERVICE_NAME_BASE = ServiceName.JBOSS.append(new String[]{"data-source-config"});
    private final ModifiableDataSource dataSourceConfig;
    private final Map<String, Supplier<String>> connectionProperties;

    public DataSourceConfigService(ModifiableDataSource dataSourceConfig, Map<String, Supplier<String>> connectionProperties) {
        this.dataSourceConfig = dataSourceConfig;
        this.connectionProperties = connectionProperties;
    }

    public void start(StartContext startContext) throws StartException {
        for (Map.Entry<String, Supplier<String>> connectionProperty : this.connectionProperties.entrySet()) {
            this.dataSourceConfig.addConnectionProperty(connectionProperty.getKey(), connectionProperty.getValue().get());
        }
    }

    public void stop(StopContext stopContext) {
    }

    public ModifiableDataSource getValue() {
        return this.dataSourceConfig;
    }
}

