/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.counter.operation;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import org.infinispan.client.hotrod.counter.operation.BaseCounterOperation;
import org.infinispan.client.hotrod.impl.operations.CacheUnmarshaller;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.counter.api.CounterConfiguration;

public class CompareAndSwapOperation
extends BaseCounterOperation<Long> {
    private final long expect;
    private final long update;
    private final CounterConfiguration counterConfiguration;

    public CompareAndSwapOperation(String counterName, long expect, long update, CounterConfiguration counterConfiguration) {
        super(counterName, true);
        this.expect = expect;
        this.update = update;
        this.counterConfiguration = counterConfiguration;
    }

    @Override
    public void writeOperationRequest(Channel channel, ByteBuf buf, Codec codec) {
        super.writeOperationRequest(channel, buf, codec);
        buf.writeLong(this.expect);
        buf.writeLong(this.update);
    }

    @Override
    public Long createResponse(ByteBuf buf, short status, HeaderDecoder decoder, Codec codec, CacheUnmarshaller unmarshaller) {
        this.checkStatus(status);
        this.assertBoundaries(status);
        assert (status == 0);
        return buf.readLong();
    }

    private void assertBoundaries(short status) {
        if (status == 4) {
            if (this.update >= this.counterConfiguration.upperBound()) {
                throw Log.HOTROD.counterOurOfBounds("Upper bound");
            }
            throw Log.HOTROD.counterOurOfBounds("Lower bound");
        }
    }

    @Override
    public short requestOpCode() {
        return 88;
    }

    @Override
    public short responseOpCode() {
        return 89;
    }
}

