/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import org.infinispan.client.hotrod.impl.ClientStatistics;
import org.infinispan.client.hotrod.impl.operations.CacheUnmarshaller;
import org.infinispan.client.hotrod.impl.operations.DelegatingHotRodOperation;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;

public class StatisticOperation<E>
extends DelegatingHotRodOperation<E> {
    private final ClientStatistics statistics;
    private long startTime;

    protected StatisticOperation(HotRodOperation<E> delegate, ClientStatistics statistics) {
        super(delegate);
        this.statistics = statistics;
    }

    @Override
    public void writeOperationRequest(Channel channel, ByteBuf buf, Codec codec) {
        super.writeOperationRequest(channel, buf, codec);
        this.startTime = this.statistics.time();
    }

    @Override
    public E createResponse(ByteBuf buf, short status, HeaderDecoder decoder, Codec codec, CacheUnmarshaller unmarshaller) {
        Object responseValue = super.createResponse(buf, status, decoder, codec, unmarshaller);
        this.delegate.handleStatsCompletion(this.statistics, this.startTime, status, responseValue);
        return (E)responseValue;
    }
}

