/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.health;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.LocalModelControllerClient;
import org.jboss.as.controller.ModelControllerClientFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.management.Capabilities;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.health.HealthSubsystemDefinition;
import org.wildfly.extension.health.ServerProbe;
import org.wildfly.extension.health.ServerProbes;

public class ServerProbesService
implements Service {
    private Consumer<ServerProbesService> consumer;
    private final Supplier<ModelControllerClientFactory> modelControllerClientFactory;
    private final Supplier<Executor> managementExecutor;
    private LocalModelControllerClient modelControllerClient;
    private final Set<ServerProbe> serverProbes = new HashSet<ServerProbe>();

    static void install(OperationContext context) {
        CapabilityServiceBuilder sb = context.getCapabilityServiceTarget().addCapability(HealthSubsystemDefinition.SERVER_HEALTH_PROBES_CAPABILITY);
        Consumer consumer = sb.provides(new ServiceName[]{HealthSubsystemDefinition.SERVER_HEALTH_PROBES_CAPABILITY.getCapabilityServiceName()});
        Supplier modelControllerClientFactory = sb.requires(ModelControllerClientFactory.SERVICE_DESCRIPTOR);
        Supplier managementExecutor = sb.requires(Capabilities.MANAGEMENT_EXECUTOR);
        sb.setInstance((Service)new ServerProbesService(consumer, modelControllerClientFactory, managementExecutor)).install();
    }

    private ServerProbesService(Consumer<ServerProbesService> consumer, Supplier<ModelControllerClientFactory> modelControllerClientFactory, Supplier<Executor> managementExecutor) {
        this.consumer = consumer;
        this.modelControllerClientFactory = modelControllerClientFactory;
        this.managementExecutor = managementExecutor;
    }

    public void start(StartContext context) throws StartException {
        this.modelControllerClient = this.modelControllerClientFactory.get().createSuperUserClient(this.managementExecutor.get(), true);
        this.serverProbes.add(new ServerProbes.ServerStateCheck(this.modelControllerClient));
        this.serverProbes.add(new ServerProbes.SuspendStateCheck(this.modelControllerClient));
        this.serverProbes.add(new ServerProbes.DeploymentsStatusCheck(this.modelControllerClient));
        this.serverProbes.add(new ServerProbes.NoBootErrorsCheck(this.modelControllerClient));
        this.consumer.accept(this);
    }

    public void stop(StopContext context) {
        this.serverProbes.clear();
        this.consumer.accept(null);
        this.modelControllerClient.close();
    }

    public Set<ServerProbe> getServerProbes() {
        return this.serverProbes;
    }
}

